<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_repo_categories_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('repo_categories'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 11,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'`parent_id` int(11) unsigned DEFAULT NULL',
				'cat_id' => array(
					'type' => 'VARCHAR',
					'constraint' => 150,
					'default' => NULL,
					'null' => TRUE,
				),
				'business_partner' => array(
					'type' => 'VARCHAR',
					'constraint' => 450,
					'default' => NULL,
					'null' => TRUE,
				),
				'category_name' => array(
					'type' => 'VARCHAR',
					'constraint' => 255,
				),
				'`admin_id` int(11) DEFAULT NULL',
				'short_desc' => array(
					'type' => 'TEXT',
				),
				'image' => array(
					'type' => 'VARCHAR',
					'constraint' => 200,
				),
				'order' => array(
					'type' => 'INT',
					'constraint' => 11,
				),
				'`created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
				'`updated_at` timestamp NULL DEFAULT NULL',
				'KEY `parent_id` (`parent_id`)',
				'CONSTRAINT `repo_categories_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `repo_categories` (`id`)',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('repo_categories');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down()
	{
		if($this->db->table_exists('repo_categories'))
			$this->dbforge->drop_table('repo_categories');
	}
}