<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_repo_docs_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('repo_docs'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 11,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'`category_id` int(11) unsigned DEFAULT NULL',
				'doc_id' => array(
					'type' => 'VARCHAR',
					'constraint' => 150,
					'default' => NULL,
					'null' => TRUE,
				),
				'business_partner' => array(
					'type' => 'VARCHAR',
					'constraint' => 450,
					'default' => NULL,
					'null' => TRUE,
				),
				'name' => array(
					'type' => 'VARCHAR',
					'constraint' => 255,
				),
				'`admin_id` int(11) DEFAULT NULL',
				'description' => array(
					'type' => 'TEXT',
				),
				'last_update' => array(
					'type' => 'DATE',
					'default' => '0000-00-00',
				),
				'version' => array(
					'type' => 'TEXT',
				),
				'issuer' => array(
					'type' => 'VARCHAR',
					'constraint' => 50,
				),
				'image' => array(
					'type' => 'VARCHAR',
					'constraint' => 200,
				),
				'order' => array(
					'type' => 'INT',
					'constraint' => 11,
					'default' => 0,
				),
				'link' => array(
					'type' => 'VARCHAR',
					'constraint' => 200,
				),
				'doc' => array(
					'type' => 'VARCHAR',
					'constraint' => 512,
				),
				'push' => array(
					'type' => 'TINYINT',
					'constraint' => 1,
					'default' => 0,
				),
				'`created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
				'`updated_at` timestamp NULL DEFAULT NULL',
				'KEY `category_id` (`category_id`)',
				'KEY `category_id_2` (`category_id`)',
				'CONSTRAINT `repo_docs_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `repo_categories` (`id`)',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('repo_docs');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down()
	{
		if($this->db->table_exists('repo_docs'))
			$this->dbforge->drop_table('repo_docs');
	}
}