<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_users_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('users'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'INT',
					'constraint' => 10,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'user' => array(
					'type' => 'VARCHAR',
					'constraint' => 20,
				),
				'`admin_id` int(11) DEFAULT NULL',
				'password' => array(
					'type' => 'VARCHAR',
					'constraint' => 128,
				),
				'fullname' => array(
					'type' => 'VARCHAR',
					'constraint' => 50,
				),
				'role' => array(
					'type' => 'VARCHAR',
					'constraint' => 255,
				),
				'image' => array(
					'type' => 'VARCHAR',
					'constraint' => 200,
				),
				'url' => array(
					'type' => 'VARCHAR',
					'constraint' => 75,
				),
				'email' => array(
					'type' => 'VARCHAR',
					'constraint' => 100,
				),
				'telephone' => array(
					'type' => 'VARCHAR',
					'constraint' => 20,
				),
				'schedule' => array(
					'type' => 'VARCHAR',
					'constraint' => 255,
				),
				'company' => array(
					'type' => 'VARCHAR',
					'constraint' => 60,
				),
				'address' => array(
					'type' => 'VARCHAR',
					'constraint' => 120,
				),
				'zip' => array(
					'type' => 'VARCHAR',
					'constraint' => 7,
				),
				'city' => array(
					'type' => 'VARCHAR',
					'constraint' => 35,
				),
				'main_manager' => array(
					'type' => 'TINYINT',
					'constraint' => 1,
				),
				'user_role' => array(
					'type' => 'TINYINT',
					'constraint' => 4,
					'default' => 1,
					'null' => TRUE,
				),
				'business_partner' => array(
					'type' => 'VARCHAR',
					'constraint' => 450,
					'default' => NULL,
					'null' => TRUE,
				),
				'`created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP',
				'`updated_at` timestamp NULL DEFAULT NULL',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('users');
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down()
	{
		if($this->db->table_exists('users'))
			$this->dbforge->drop_table('users');
	}
}