<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Create_languages_table extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->table_exists('languages'))
		{
			$this->dbforge->add_field(array(
				'id' => array(
					'type' => 'TINYINT',
					'constraint' => 3,
					'unsigned' => TRUE,
					'auto_increment' => TRUE,
				),
				'iso' => array(
					'type' => 'VARCHAR',
					'constraint' => 3,
				),
				'name' => array(
					'type' => 'VARCHAR',
					'constraint' => 30,
				),
				'order' => array(
					'type' => 'TINYINT',
					'constraint' => 3
				),
				'UNIQUE KEY `languages_iso_unique` (`iso`)',
			));
			$this->dbforge->add_key('id', TRUE);

			$this->dbforge->create_table('languages');

			$data = array(
				array(
					'iso' => 'en',
					'name' => 'English',
					'order' => 1,
				),
				array(
					'iso' => 'es',
					'name' => 'Español',
					'order' => 5,
				),
				array(
					'iso' => 'de',
					'name' => 'Deutsch',
					'order' => 2,
				),
				array(
					'iso' => 'it',
					'name' => 'Italiano',
					'order' => 4,
				),
				array(
					'iso' => 'fr',
					'name' => 'Français',
					'order' => 3,
				),
			);
			$this->db->insert_batch('languages', $data);
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down()
	{
		if($this->db->table_exists('languages'))
			$this->dbforge->drop_table('languages');
	}
}