<?php
 /**
  * Migration 
  *
  * This is the migration used to docs_assignment_repo_docs table.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Controllers
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Migration_Create_docs_assignment_repo_docs_table - Migration
  *
  * Migration for docs_assignment_repo_docs table.
  */
class Migration_Add_language_admin extends CI_Migration
{
	/**
	  * Called by system whenever you need to update the database 
	  */
	public function up()
	{
		if(!$this->db->field_exists('language_id', 'admin'))
		{
			$this->dbforge->add_column('admin', array(
				'language_id' => array(
					'type' => 'TINYINT',
					'constraint' => 3,
					'unsigned' => TRUE,
					'default' => 1,
				),
				'KEY `language_id` (`language_id`)',
				'CONSTRAINT `admin_ibfk_1` FOREIGN KEY (`language_id`) REFERENCES `languages` (`id`)',
			));
		}
	}

	/**
	  * Used to revert that change that was done by the up() method 
	  */
	public function down()
	{
		if($this->db->field_exists('language_id', 'admin'))
		{
			$this->db->query('ALTER TABLE admin DROP FOREIGN KEY admin_ibfk_1');
			$this->dbforge->drop_column('admin', 'language_id');
		}
	}
}