<?php
 /**
  * Model for clients table
  *
  * This is the model for clients table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Clients_m - Model
  *
  * Model for clients table.
  */
class Clients_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "clients";

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Fetch a single record based on External ID column. Return an array
	  *
	  * @param int $id ID
	  *
	  * @return array
	  */
	function get_by_external_id($id)
	{
		$this->primary_key	= 'external_id';
		$results			= $this->get_one($id);
		$this->primary_key	= 'id';

		return $results;
	}

	/**
	  * Delete rows based on External ID column. Return affected rows
	  *
	  * @param int $id ID
	  *
	  * @return array
	  */
	function delete_external_id($id)
	{
		$this->primary_key	= 'external_id';
		$this->delete($id);
		$this->primary_key	= 'id';

		return $this->db->affected_rows();
	}

	/**
	  * This callback runs on the read_table method.
	  * With this opportunity you can implement other database instructions like join.
	  *
	  */
	function _callback_table()
	{
		$this->db->join('clients_categories', 'LOWER('.$this->table.'.id)=LOWER(clients_categories.client_id) and LOWER(clients_categories.isinvoice)=1', 'LEFT');
		if($this->session->userdata('user_role') == 2)
		{
			$this->db->where('clients.partner_id',$this->session->userdata('business_partner'));
		}
	}

	/**
	  * Updated a record based on external_id column.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  *
	  * @return false|int
	  */
	function update_by_external_id($id, $data)
	{
		$this->primary_key	= 'external_id';
		$results			= $this->update($id, $data);
		$this->primary_key	= 'id';

		return $results;
	}

	/**
	  * Fetch a single record based on Client ID. Return an primary key value
	  *
	  * @param int $client_id Client ID
	  *
	  * @return array
	  */
	function checkclientinvoice($client_id)
	{
		$query				= $this->db->where('client_id', $client_id)
							->where('category_name', 'Invoice')
							->where('isinvoice', 1)
							->get('clients_categories');

		if($query->num_rows() > 0)
		{
			$category			= $query->row_array();

			return $category['id'];
		} else {
			return 0;
		}
	}

	/**
	  * Insert a new row into the table with isinvoice column setter to 1 or update if exist data for provided Client ID param.
	  *
	  * @param int $client_id Client ID
	  *
	  * @return int
	  */
	function clientinvoice($client_id)
	{
		$query				= $this->db->where('client_id', $client_id)
							->where('category_name', 'Invoice')
							->where('isinvoice', 1)
							->get('clients_categories');

		if($query->num_rows() > 0)
		{
			$category			= $query->row_array();

			$this->db->where('id', $category['id'])
				->update('clients_categories', array("isinvoice" => "0"));

			return $category['id'];
		} else {
			$query				= $this->db->where('client_id', $client_id)
								->where('category_name', 'Invoice')
								->get('clients_categories');

			if($query->num_rows() > 0)
			{
				$category			= $query->row_array();

				$this->db->where('id', $category['id'])
					->update('clients_categories', array("isinvoice" => "1"));

				return $category['id'];
			} else {
				$this->db->insert("clients_categories", array(
					'client_id'			=> $client_id,
					'category_name'		=> 'Invoice',
					'isinvoice'			=> 1,
					'order'				=> 0
				));

				return $this->db->insert_id();
			}
		}
	}
}