<?php
 /**
  * Model for docs_assignment_repo_docs table
  *
  * This is the model for docs_assignment_repo_docs table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Docs_assignment_repo_docs_m - Model
  *
  * Model for docs_assignment_repo_docs table.
  */
class Docs_assignment_repo_docs_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "docs_assignment_repo_docs";

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Retrieve IDs of documents assigned to a specified client
	  *
	  * @param int $client_id Client ID
	  *
	  * @return array
	  */
	function get_ids_by_client_id($client_id)
	{
		$this->load->model('clients_m');
		$this->load->model('docs_assignment_users_m');

		$client 			= $this->clients_m->get_one($client_id);
		$docs_assigments	= $this->docs_assignment_users_m->get_by_client($client['id']);
		$return				= array();
		foreach($docs_assigments as $doc_assigment)
		{
			$repo_docs_ids		= $this->db->select('repo_doc_id')
								->where('docs_assignment_id', $doc_assigment['docs_assignment_id'])
								->get($this->table)
								->result_array();
			foreach($repo_docs_ids as $doc)
			{
				$return[]			= $doc['repo_doc_id'];
			}
		}

		return $return;
	}
}