<?php
 /**
  * Model for docs_bundles table
  *
  * This is the model for docs_bundles table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Docs_bundles_m - Model
  *
  * Model for docs_bundles table.
  */
class Docs_bundles_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "docs_bundles";
	 /** @var int This is private var to use on this class. */
	var $cust_save_data_copy;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * This callback runs on the read_table method.
	  * With this opportunity you can implement other database instructions like join.
	  *
	  */
	function _callback_table()
	{
		if($this->session->userdata('user_role') == 2){
			$this->db->where('docs_bundles.business_partner',$this->session->userdata('business_partner'));
		}
	}

	/**
	  * Retrieve and generate a form_dropdown friendly array
	  *
	  * @return array
	  */
	function get_repo_docs_list()
	{
		if($this->session->userdata('user_role') == 2)
		{
			$query				= $this->db->select(array('id','name'))
								->where('business_partner', $this->session->userdata('business_partner'))
								->distinct()
								->get('repo_docs');
		} else {
			$query				= $this->db->select(array('id','name'))
								->distinct()
								->get('repo_docs');
		}

		$list				= [];
		foreach($query->result_array() as $data)
		{
			$list[]				= [
				'value'				=> $data['id'],
				'text'				=> $data['name'],
			];
		}

		return $list;
	}

	/**
	  * Retrieve and generate a form_dropdown friendly array
	  *
	  * @param int $bp Business partner
	  *
	  * @return array
	  */
	function get_repo_docs_list_by_bp($bp)
	{
		$query				= $this->db->select(array('id','name'))
							->where('business_partner', $bp)
							->distinct()
							->get('repo_docs');

		$list				= [];
		foreach($query->result_array() as $data)
		{
			$list[]				= [
				'value'				=> $data['id'],
				'text'				=> $data['name'],
			];
		}
		return $list;
	}

	/**
	  * This callback runs before save of the crud.
	  * The callback takes as a 1st parameter the primary key value and as 2nd the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  */
	function _before_save($id, &$data)
	{
		$this->cust_save_data_copy = $data;
		unset($data['repo_doc_id']);
		if($this->table == "docs_bundles" && $this->session->userdata['user_role'] == 2)
		{
			$data['business_partner'] = $this->session->userdata['business_partner'];
		}
	}

	/**
	  * This callback runs after the insert/update of the crud.
	  * The callback takes as a 1st parameter the primary key value.
	  * With this opportunity you can do other actions after insert/update.
	  *
	  * @param int $id Primary key
	  */
	function _after_save($id)
	{
		if($this->table == "docs_bundles")
		{
			$this->set_repo_docs_to_bundle($id, $this->cust_save_data_copy['repo_doc_id']);
		}
	}
	/**
	  * Insert a new rows & delete deprecateds
	  *
	  * @param int $id ID
	  * @param array $repo_docs_array Array of Document IDs
	  */
	function set_repo_docs_to_bundle($id, $repo_docs_array)
	{
		$results			= $this->db->select('repo_doc_id')
							->where('docs_bundles_id', $id )
							->get('docs_bundles_repo_docs')
							->result_array();
		
		if(count($results) > 0)
		{
			$repo_doc_ids		= [];
			
			foreach($results as $data)
			{
				array_push($repo_doc_ids, $data['repo_doc_id']);
			}
			
			if(!$repo_docs_array){
				$repo_docs_array	= [];
			}
			
			$diff_ids			= array_intersect($repo_doc_ids, $repo_docs_array);
			$new_insert_ids		= array_diff($repo_docs_array, $diff_ids);
			$del_insert_ids		= array_diff($repo_doc_ids, $diff_ids);
			
			if(count($del_insert_ids) > 0)
			{	
				foreach($del_insert_ids as $value)
				{
					$this->db->where('repo_doc_id', $value)
						->delete("docs_bundles_repo_docs");
				}
			}
			if(count($new_insert_ids) > 0)
			{
				foreach($new_insert_ids as $value)
				{
					$this->db->insert("docs_bundles_repo_docs", ["docs_bundles_id" => $id, "repo_doc_id" => $value]);
				}
			}
		} else {
			foreach($repo_docs_array as $value)
			{
				$this->db->insert("docs_bundles_repo_docs", ["docs_bundles_id" => $id, "repo_doc_id" => $value]);
			}
		}

		return true;
	}
}	