<?php
 /**
  * Model for admin table
  *
  * This is the model for admin table extended from MY_Model.
  * With this model we can manage user with role manager
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Managers_m - Model
  *
  * Model for admin table.
  */
class Managers_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "admin";
	 /** @var int This is private var to use on this class. */
	var $save_data_copy;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * This callback runs on the read_table method.
	  * With this opportunity you can implement other database instructions like join.
	  *
	  */
	function _callback_table()
	{
		$this->db->where('user_role', 2);
	}

	/**
	  * This callback runs before save of the crud.
	  * The callback takes as a 1st parameter the primary key value and as 2nd the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  */
	function _before_save($id, &$data)
	{
		if(isset($data['password']) && empty($data['password']))
		{
			unset($data['password']);
		}
		if(isset($data['password']))
		{
			$data['password'] = md5($data['password']);
		}

		$this->save_data_copy = $data;
	}

	/**
	  * Retrieve and generate a form_dropdown friendly array
	  *
	  * @return array
	  */
	function get_business_partnerlist()
	{
		$query				= $this->db->select('partner_id')
							->distinct()
							->get('clients');

		$list				= [
			array(
				'value'				=> '',
				'text'				=> lang('selectAPartner')
			)
		];
		foreach($query->result_array() as $data)
		{
			$list[]				= [
				'value'				=> $data['partner_id'],
				'text'				=> $data['partner_id'],
			];
		}

		return $list;
	}
}