<?php
 /**
  * Model for notifications_clients table
  *
  * This is the model for notifications_clients table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Notifications_clients_m - Model
  *
  * Model for notifications_clients table.
  */
class Notifications_clients_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "notifications_clients";

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Fetch all the records in the table filtered by params.
	  *
	  * @param int $external_id External ID
	  * @param null|int $limit Limit
	  * @param null|string $order_field Order field
	  * @param string $order_direction Order direction
	  *
	  * @return array
	  */
	function get_by_external_id($external_id, $limit=NULL, $order_field=NULL, $order_direction='DESC')
	{
		$this->db->select('notifications.*');

		if($limit!=NULL)
		{
			$this->db->limit($limit);
		}

		if($order_field!=NULL)
		{
			$this->db->order_by($order_field, $order_direction);
		}
		
		$this->db->join('clients', $this->table.'.client_id = clients.id')
			->join('notifications', $this->table.'.notification_id = notifications.id')
			->where('clients.external_id', $external_id);

		return $this->get_all();
	}

	/**
	  * This callback runs on the read_table method.
	  * With this opportunity you can implement other database instructions like join.
	  *
	  */
	function _callback_table()
	{
		$this->db->join('clients', $this->table.'.client_id = clients.id');
		$this->db->join('notifications', $this->table.'.notification_id = notifications.id');
	}
}