<?php
 /**
  * Model for notifications table
  *
  * This is the model for notifications table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Notifications_m - Model
  *
  * Model for notifications table.
  */
class Notifications_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "notifications";

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * This callback runs before save of the crud.
	  * The callback takes as a 1st parameter the primary key value and as 2nd the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  */
	protected function _before_save($id, &$data)
	{
		$data['admin_id']	= $this->session->userdata('manager');
		$data['updated_at']	= date('Y-m-d H:i:s');
	}

	/**
	  * This callback runs on the read_table method.
	  * With this opportunity you can implement other database instructions like join.
	  *
	  */
	function _callback_table()
	{
		$this->db->join('admin', 'LOWER('.$this->table.'.admin_id) = LOWER(admin.id)', 'LEFT');
	}
}