<?php
 /**
  * Model for repo_docs table
  *
  * This is the model for repo_docs table extended from MY_Model.
  *
  * @author Innoxess Spain, S.L. <hola@innoxess.es>
  * @copyright 2015-2018 Innoxess Spain, S.L.
  * @package  Application
  * @subpackage Models
  *
  */
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 /**
  * Class Repo_docs_m - Model
  *
  * Model for repo_docs table.
  */
class Repo_docs_m extends MY_Model
{
	 /** @var string This is the database table for this model. */
	var $table = "repo_docs";
	 /** @var int This is private var to use on this class. */
	private $category_id;

	/**
	  * Constructor
	  */
	function __construct()
	{
		parent::__construct();
	}

	/**
	  * Make an array of categories Ids.
	  *
	  * @param int $doc_id Document id.
	  *
	  * @return array
	  */
	function get_cats_branch($doc_id)
	{
		$doc				= $this->get_one($doc_id);
		if(isset($doc['category_id']))
		{
			$this->load->model('repo_categories_m');

			return $this->repo_categories_m->get_cats_branch($doc['category_id']);
		}

		return array();
	}

	/**
	  * Set private var category_id.
	  *
	  * @param int|null $category_id Category ID
	  */
	function set_category_id($category_id)
	{
		$this->category_id = $category_id;
	}

	/**
	  * Check if private var category_id is setter to concat on data array.
	  *
	  * @param array $data Post Array
	  */
	private function save_model_data(&$data)
	{
		if(isset($this->category_id) && !isset($data['category_id']))
		{
			$data['category_id'] = $this->category_id;
		}
	}

	/**
	  * This callback runs before save of the crud.
	  * The callback takes as a 1st parameter the primary key value and as 2nd the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  */
	protected function _before_save($id, &$data)
	{
		$data['admin_id']	= $this->session->userdata('manager');
		$data['updated_at'] = date('Y-m-d H:i:s');
	}

	/**
	  * This callback runs before the insert of the crud.
	  * The callback takes as a 1st parameter the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param array $data Array
	  */
	function _before_insert(&$data)
	{
		$this->_default_image($data);
		$this->save_model_data($data);
	}

	/**
	  * This callback runs before the update of the crud.
	  * The callback takes as a 1st parameter the primary key value and as 2nd the post array.
	  * With this opportunity you can add or unset some post variables.
	  *
	  * @param int $id Primary key
	  * @param array $data Array
	  */
	function _before_update($id, &$data)
	{
		$this->_default_image($data);
		$this->save_model_data($data);
	}

	/**
	  * Check on provided array if image key is empty to retrieve from database based on business_partner key.
	  *
	  * @param array $data Post Array
	  */
	function _default_image(&$data)
	{
		if($data['image'] == '')
		{
			$bp					= $this->db->where('bp_id', $data['business_partner'])
								->get('business_partners')
								->row();
			if(isset($bp->default_document_image))
			{
				$image				= $bp->default_document_image;
				@exec('cp '.BASE_UPLOAD.'business_partners'.$image.' '.BASE_UPLOAD.'image_docs'.$image);
				$data['image']		= $image;
			}
		}
	}

	/**
	  * Fetch all the records in the table filtered by Category ID
	  *
	  * @param int|null $cat_id Category ID
	  *
	  * @return array
	  */
	function get_by_category_id($cat_id=NULL)
	{
		if($cat_id==NULL)
		{
			$this->db->where('category_id IS null');
		}else{
			$this->db->where('category_id', $cat_id);
		}

		if($this->session->userdata('user_role') == 2)
		{
			$this->db->where('business_partner', $this->session->userdata('business_partner'));
		}

		return $this->get_all();
	}

	/**
	  * Fetch a single record based on Doc ID column. Return an array
	  *
	  * @param int $id ID
	  *
	  * @return array
	  */
	function get_by_doc_id($id)
	{
		$query				= $this->db->where('doc_id', $id)->get($this->table);

		return $query->row_array();
	}

	/**
	  * Return id & name of all the records in the table
	  *
	  * @param int $bp Business partner
	  *
	  * @return array
	  */
	function get_repo_docs_list_by_bp($bp)
	{
		return $this->db->select(array('id','name'))
			->where('business_partner', $bp)
			->distinct()
			->get($this->table)
			->result_array();
	}

	/**
	  * Fetch all the records in the table filtered by Array of Document IDs & Category ID
	  *
	  * @param array $docs_ids Arrays of IDs
	  * @param null|int $category_id Category ID
	  *
	  * @return array
	  */
	function get_filtered_by_category_id($docs_ids, $category_id=NULL)
	{
		if(empty($docs_ids))
		{
			return array();
		}

		$this->db->where_in('id', $docs_ids);
		if($category_id==NULL)
		{
			$this->db->where('category_id IS null');
		}else{
			$this->db->where('category_id', $category_id);
		}

		return $this->get_all();
	}

	/**
	  * Fetch a single record based on the primary key. Return an array
	  *
	  * @param int $id ID
	  *
	  * @return array
	  */
	function get_custom_one($id)
	{
		$query			= $this->db->join('admin', 'admin.id = '.$this->table.'.admin_id', 'left outer')
						->select($this->table.'.*, admin.user as user, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key)
						->where($this->table.'.'.$this->primary_key, $id)
						->get($this->table);

		return $this->_get_virtuals($id, $query->row_array());
	}

	/**
	  * Retrieve number of rows found on database filtered by doc_id column.
	  *
	  * @param int $doc_ID ID
	  *
	  * @return array
	  */
	function checkrepodocumentbydocid($doc_ID)
	{
		return $this->db->where('doc_id', $doc_ID)
			->get($this->table)
			->num_rows();
	}

	/**
	  * Insert a new row into the table. $data should be an associative array of data to be inserted. Returns newly created ID.
	  *
	  * @param array $data Post Data
	  *
	  * @return int
	  */
	function setrepodocument($data)
	{
		$this->db->insert($this->table, $data);

		return $this->db->insert_id();
	}

	/**
	  * Updated a record based on the doc_id column
	  *
	  * @param int $doc_ID ID
	  * @param array $data Post Data
	  *
	  * @return int
	  */
	function updaterepodocument($doc_ID, $data)
	{
		$this->db->where('doc_id', $doc_ID)
			->update($this->table, $data);

		return $this->db->affected_rows();
	}

	/**
	  * Delete a row from the table by the doc_id column
	  *
	  * @param int $doc_ID ID
	  *
	  * @return int
	  */
	function deleterepodocument($doc_ID)
	{
		$this->db->where('doc_id', $doc_ID)->delete($this->table);

		return $this->db->affected_rows();
	}
}