//
//  ContactViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 13/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Kingfisher
import MessageUI

class ContactViewController: UIViewController , UITextViewDelegate, MFMailComposeViewControllerDelegate {
    
    @IBOutlet weak var scrollView: UIScrollView!
    
    var user : userObject?
    var contact : ContactObject?
    var partner : String?
    var releaseM : ReleaseManager?
    var urlManager : URLBaseManager?
    
    @IBOutlet weak var mailTextView: UITextView!
    
    @IBOutlet weak var sendButton: UIButton!
    
    @IBAction func sendAction(sender: AnyObject)
    {
        
        if let mail = self.contact?.email
        {
            sendEmail(mail,subject:"LindauFiber Support",body:self.mailTextView.text)
        }
    }
    
   
    @IBOutlet weak var resetButton: UIButton!
    
    @IBAction func resetMailText(sender: UIButton) {
        
        self.mailTextView.text = ""
    }
   
    
    
    @IBOutlet weak var navBarInfo: UIImageView!
    
    @IBOutlet weak var contactImage: UIImageView!
    
    @IBOutlet weak var contactName: UILabel!
    
    @IBOutlet weak var contactTelephone: UILabel!
    
    @IBOutlet weak var contactEmail: UILabel!

    @IBOutlet weak var contactInfo: UITextView!
    
    func sendEmail(mail:String, subject: String, body:String) {
        
        
        let recipient = ["\(mail)"]
        
        debugPrint(recipient)
        
        if MFMailComposeViewController.canSendMail() {
            let mail = MFMailComposeViewController()
            mail.mailComposeDelegate = self
            mail.setToRecipients(recipient)
            mail.setSubject(subject)
            mail.setMessageBody("\(body)", isHTML: false)
            
            presentViewController(mail, animated: true, completion: nil)
        } else {
            alertMessage()
        }
    }
    
    func alertMessage()
    {
        dispatch_async(dispatch_get_main_queue()) {
            
            let alert = UIAlertController(title: "Could Not Send Email", message: "Your device could not send e-mail.  Please check e-mail configuration and try again.", preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title: "Ok", style: UIAlertActionStyle.Default, handler: { (UIAlertAction) -> Void in
                alert.dismissViewControllerAnimated(true, completion: nil)
            }))
            
            self.presentViewController(alert, animated: true, completion: nil)
            
        }
    }

    func mailComposeController(controller: MFMailComposeViewController, didFinishWithResult result: MFMailComposeResult, error: NSError?) {
        controller.dismissViewControllerAnimated(true, completion: nil)
    }
    
    
    
    func partnerSettings()
    {
        if let name = self.partner
        {
            releaseM = ReleaseManager(initWithPartner: name)
            self.navBarInfo.image = UIImage(imageLiteral: (releaseM?.navBarColor)!)
            self.sendButton.backgroundColor = releaseM?.color
        }
    }
    
    
    
    func contactInfoParsed()
    {
        
       
        self.mailTextView.delegate = self
        self.contactName.text = self.contact?.fullName
        self.contactTelephone.text = self.contact?.telephone
        self.contactEmail.text = self.contact?.email
     
        self.contactInfo.text = "\((self.contact?.company)!)\n\((self.contact?.address)!)\n\((self.contact?.zip)!)\n\((self.contact?.city)!)\nOpening Schedule:\n\((self.contact?.schedule)!)"
        let token = (NSUserDefaults.init().objectForKey("token"))!
        
        if let id = self.contact?.idNumber
        {
            if let url = NSURL(string: "\((urlManager?.ContactAvatarURL)!)access_token=\(token)&id=\(id)")
            {
                debugPrint(url)
                self.contactImage.kf_setImageWithURL(url, placeholderImage: UIImage(imageLiteral:"contact") )
            }
        }
      
       
            
    

    }
    
    func backToMainMenu()
    {
        self.dismissViewControllerAnimated(true) { () -> Void in
            
        }
        
    }
    
    
    func keyboardWillShowNotification(notification: NSNotification) {
        
        dispatch_async(dispatch_get_main_queue()) {
            
            UIView.animateWithDuration(0.5, animations: { () -> Void in
                self.scrollView.setContentOffset(CGPointMake(0, 250), animated: true)
            })
            
        }
        
    }
    
    func keyboardWillHideNotification(notification: NSNotification) {
        
        dispatch_async(dispatch_get_main_queue()) {
            
            UIView.animateWithDuration(0.5, animations: { () -> Void in
                self.scrollView.setContentOffset(CGPointMake(0, 0), animated: true)
            })
            
        }
        
        
    }
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        partnerSettings()
        urlManager = URLBaseManager.sharedInstance
        contactInfoParsed()
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "keyboardWillShowNotification:", name: UIKeyboardWillShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "keyboardWillHideNotification:", name: UIKeyboardWillHideNotification, object: nil)

        let swipeGesture : UISwipeGestureRecognizer = UISwipeGestureRecognizer.init(target: self, action: Selector("backToMainMenu"))
        swipeGesture.direction = .Down
        self.view!.addGestureRecognizer(swipeGesture)

        // Do any additional setup after loading the view.
    }

    override func viewWillDisappear(animated: Bool) {
        super.viewWillDisappear(animated)
        
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardWillShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardWillHideNotification, object: nil)
    
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
 
    
    func textView(textView: UITextView, shouldChangeTextInRange range: NSRange, replacementText text: String) -> Bool {
        if text == "\n" {
            self.mailTextView.resignFirstResponder()
            return false
        }
        return true
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
