//
//  MenuDocViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 17/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit

private let reuseIdentifier = "menuDocCell"


class MenuDocViewController: UIViewController, UICollectionViewDataSource, UICollectionViewDelegate, UIGestureRecognizerDelegate {
    
    var userTreeArray = [DocsCategoriesDemo]()
    var repoTreeArray = [DocsCategoriesDemo]()
    var menuTreesArray = [DocsCategoriesDemo]()
    var docsCategory : DocsCategoriesDemo?
    var partnership : String?
    var treeToShow : String?
    var userOb : userObject?
    var brandInf : BrandingInfo?
    var docsCategoriesDemo : DocsCategoriesDemo?
    
    @IBOutlet weak var menuDocCollectionView: UICollectionView!
    

     func settingBrandingInfo() {
        
        
        brandInf = self.userOb?.partnerI?.brandInf
        
        if let brand = brandInf
        {
            
            self.view.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
            menuDocCollectionView.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
        }
        
    }
    
    override func viewWillAppear(animated: Bool) {
        
        super.viewWillAppear(animated)
       
        debugPrint(self.menuTreesArray.count)
        settingBrandingInfo()
        
        let logOutGestureLeft : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureLeft.direction = UISwipeGestureRecognizerDirection.Left
        self.view.addGestureRecognizer(logOutGestureLeft)
        
        let logOutGestureRight : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureRight.direction = UISwipeGestureRecognizerDirection.Right
        self.view.addGestureRecognizer(logOutGestureRight)
        
    }
    
    
    
    func backToMainMenu()
    {
        
        self.dismissViewControllerAnimated(true, completion: nil)
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    // MARK: - Docs Creation
    
    
    
    
    
    
    //Mark Delegate and DataSource from CollectionView
    
    func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        
        return 1
    }
    
    func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        
        return self.menuTreesArray.count
        
    }
    
    
    
    func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell
    {
        
        let menuDocCell = collectionView.dequeueReusableCellWithReuseIdentifier(reuseIdentifier, forIndexPath: indexPath) as! MenuDocCollectionViewCell
        
        if let brand = brandInf
        {
            menuDocCell.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
            menuDocCell.menuLabel.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
        }
        
        
        self.docsCategoriesDemo = self.menuTreesArray[indexPath.row]
        
        menuDocCell.menuLabel.text = self.docsCategoriesDemo?.categoryName
        
        if (self.docsCategoriesDemo?.itemNumber == 1)
        {
            menuDocCell.menuImage.image = UIImage(imageLiteral: "personalDoc")
        }
        
        else if (self.docsCategoriesDemo?.itemNumber == 2)
        {
            menuDocCell.menuImage.image = UIImage(imageLiteral: "generalDoc")
        }
        
        return menuDocCell
        
    }
    
    func docsCreation(treeToShow: String)
    {
        self.treeToShow = treeToShow
        self.performSegueWithIdentifier("docMenuSegue", sender: self)
    }
    
    func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        
        debugPrint(indexPath.row)
        debugPrint(self.menuTreesArray.count)
        
        
        self.docsCategoriesDemo = self.menuTreesArray[indexPath.row]
        
        if docsCategoriesDemo?.categoryName == "General Docs"
        {
            docsCreation("repoTree")
        }
        if docsCategoriesDemo?.categoryName == "Personal Docs"
        {
            docsCreation("userTree")
        }
        

        
        
    }
    
    // MARK: - Navigation
    
    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "docMenuSegue"
        {
            let docVC = segue.destinationViewController as! DocsViewController
            
            docVC.userTreeArray = self.userTreeArray
            
            debugPrint(docVC.userTreeArray.count)
            
            docVC.repoTreeArray = self.repoTreeArray
            
            debugPrint(docVC.repoTreeArray.count)
            
            
            
            if let docWCArray = self.docsCategoriesDemo?.doctumentWithoutCategoryArray
            {
                docVC.documentWithoutCategoryArray = docWCArray
            }
            
            debugPrint(docVC.repoTreeArray)
            docVC.partnerships = self.partnership!
            docVC.hasMenu = true
            docVC.treeToShow = self.treeToShow
            docVC.userObs = self.userOb
            debugPrint(self.partnership!)
        }
        
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }


}
