//
//  PartnerInfo.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 9/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import SwiftyJSON

class PartnerInfo: NSObject {
    
    var partnerName : String?
    var partnerEmail : String?
    var partnerPhone: String?
    var partnerCompany : String?
    var partnerURL : String?
    var partnerFontColorTop : String?
    var partnerFontColorBottom : String?
    var partnerFontColorService : String?
    var partnerColorTop : String?
    var partnerColorService : String?
    
    var brandInf : BrandingInfo?
    
    
    init(jsonDictionary: [String: JSON])
    {
        super.init()
       
        self.partnerName = jsonDictionary["name"]?.stringValue
        self.partnerEmail = jsonDictionary["email"]?.stringValue
        self.partnerPhone = jsonDictionary["phone"]?.stringValue
        self.partnerCompany = jsonDictionary["company"]?.stringValue
        self.partnerURL = jsonDictionary["url"]?.stringValue
        self.partnerFontColorTop = jsonDictionary["font_color_top"]?.stringValue
        self.partnerFontColorBottom = jsonDictionary["font_color_bottom"]?.stringValue
        self.partnerFontColorService = jsonDictionary["font_color_service"]?.stringValue
        self.partnerColorTop = jsonDictionary["color_top"]?.stringValue
        self.partnerColorService = jsonDictionary["color_service"]?.stringValue
        
         brandInf = BrandingInfo()
        
        
        if let fontTop = self.partnerFontColorTop
        {
            brandInf?.cleanColorString(fontTop, part: "fontTop")
        }
        
        if let fontBottom = self.partnerFontColorBottom
        {
            brandInf?.cleanColorString(fontBottom, part: "fontBottom")
        }
        
        if let fontService = self.partnerFontColorService
        {
            brandInf?.cleanColorString(fontService, part: "fontColorService")
        }
        
        if let fontColorTop = self.partnerColorTop
        {
            brandInf?.cleanColorString(fontColorTop, part: "colorTop")
        }
        
        if let ColorService = self.partnerColorService
        {
            brandInf?.cleanColorString(ColorService, part: "colorService")
        }
    }

    

}
