//
//  ReleaseManager.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 9/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit

class ReleaseManager: NSObject {
    
    var logo : String?
    var color: UIColor?
    var appDemo : String?
    var appIdAPN : String?
    var appPartner : String?
    var navBarColor : String?
    var isHidden : Bool?
    
    init(initWithPartner : String)
    {
        super.init()
        let defaults = NSUserDefaults.standardUserDefaults()
        defaults.setObject(initWithPartner, forKey: "partner")
        getReleaseProperties(initWithPartner)
        
        
    }
    
    func getReleaseProperties(partner:String)
    {
       
        switch(partner)
        {
        case("Limmat"):
            
            self.logo = "limmat"
            self.appDemo = "demo.limmat"
            self.appIdAPN = "1011493448"
            self.appPartner = ""
            self.color = UIColor(colorLiteralRed: 0.855, green: 0.22, blue: 0.247, alpha:1)
            self.navBarColor = "menubarRed"
            self.isHidden = false
            
            break
            
        case("Lindau"):
            
            self.logo = "lindau"
            self.appDemo = "demo.lindau"
            self.appIdAPN = "1038248000"
            self.appPartner = ""
            self.color = UIColor(colorLiteralRed: 0.176, green: 0.624, blue: 0.192, alpha:1)
            self.navBarColor = "menubarGreen"
            self.isHidden = false
            
            break
            
        case("Lupenrein"):
            
            self.logo = "lupenrein"
            self.appDemo = ""
            self.appIdAPN = "1044991386"
            self.appPartner = ""
            self.color = UIColor(colorLiteralRed: 0.1215, green: 0.337, blue: 0.619, alpha:1)
            self.navBarColor = "menubarBlue"
            self.isHidden = false
            
            break
            
        default:
            break
        }
        
    }
    

}
