//
//  WebViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 1/11/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit

class WebViewController: UIViewController, UIWebViewDelegate {

    @IBOutlet weak var webView: UIWebView!
    
    @IBOutlet weak var navBarImage: UIImageView!
    @IBOutlet weak var webActivity: UIActivityIndicatorView!
    
    var partner : String?
    var releaseM : ReleaseManager?
    var webURL : String?
    
    func partnerSettings()
    {
        if let name = self.partner
        {
            releaseM = ReleaseManager(initWithPartner: name)
            self.navBarImage.image = UIImage(imageLiteral: (releaseM?.navBarColor)!)
        }
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        
         partnerSettings()
    }
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
       
       
        
        let swipeGesture : UISwipeGestureRecognizer = UISwipeGestureRecognizer.init(target: self, action: Selector("backToMainMenu"))
        swipeGesture.direction = .Down
        self.view!.addGestureRecognizer(swipeGesture)

        
        dispatch_async(dispatch_get_main_queue()) {
            let url = NSURL(string: self.webURL!)!
            debugPrint(url)
            let request:NSURLRequest = NSURLRequest(URL:url)
            self.webView.loadRequest(request)

        }
        
        

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    func backToMainMenu()
    {
        self.dismissViewControllerAnimated(true) { () -> Void in
            
        }
    
    }

    
    func webViewDidStartLoad(webView: UIWebView) {
        dispatch_async(dispatch_get_main_queue()) {
            
            self.webActivity.startAnimating()
            self.webActivity.hidden = false
            
        }
       
    }
    
    func webViewDidFinishLoad(webView: UIWebView) {
        
        dispatch_async(dispatch_get_main_queue()) {
            
            
            self.webActivity.stopAnimating()
            self.webActivity.hidden = true

            
        }

        
    }
    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
