<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin extends MY_Controller {

	var $model = 'admin_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-user-secret';
		$this->main_title = lang('menu_admin');
		$this->main_tip = lang('admin_tip');
		$this->create_title = lang('admin_create');
	}
	
	function index()
	{
		$this->_table(anchor('admin/create','<i class="fa fa-plus"></i> '.lang('admin_create'), 'class="btn btn-primary btn-sm"'));
	}
	
	function _callback_row($key, $item, &$rows)
	{
		switch ($key) {
			case 'main_manager':
				$item = $item==1 ? lang('yes') : lang('no');
				break;
			case 'image':
				$item = '<img src="'.site_url('uploader/view/avatar'.$item).'" style="display:block; margin:0 auto; border-radius: 50%; width: 50px; height: 50px;" alt="User Image">';
				break;
			case 'id':
				$id = $item;
				$item = anchor('admin/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$item .= "&nbsp;"; 
				$item .= anchor('admin/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}
}