<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_categories extends MY_Controller {

	var $model = 'clients_categories_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-folder-o';
		$this->create_title = lang('repo_categories_create');
	}
	
	function create($client_id, $parent_id=NULL)
	{
		$this->clients_categories_m->set_parent_id($parent_id);
		$this->clients_categories_m->set_client_id($client_id);
		$parent_id = $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$data = $this->_create('clients_repo/tree_panel/'.$client_id.'/'.$parent_id, '#clients_repo_tree_content');
		$this->load->view('crud/create', $data);
	}
	
	function edit($client_id, $id)
	{
		$tree_id = 'c_'.$id;
		$data = $this->_edit($id, 'clients_repo/tree_panel/'.$client_id.'/'.$tree_id, '#clients_repo_tree_content');
		$this->load->view('crud/edit', $data);
	}

	function delete($client_id, $id)
	{
		$cat = $this->clients_categories_m->get_one($id);
		$cat_id = $cat['parent_id']==NULL ? 'root' : 'c_'.$cat['parent_id'];
		$data = $this->_delete($id, 'clients_repo/tree_panel/'.$client_id.'/c_'.$id, '#clients_repo_tree_content', 'clients_repo/tree_panel/'.$client_id.'/'.$cat_id, FALSE);
		
		$this->load->view('crud/delete', $data);
	}
	
}