<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications_sents extends MY_Controller {

	var $model = 'notifications_clients_m';
	var $notification_id;

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->main_tip = lang('notifications_tip');
	}
	
	function index($notification_id)
	{
		$this->add_pre_breadcum('notifications', '<i class="fa fa-bullhorn"></i> '. lang('menu_notifications'));
		$name = strtolower(get_class($this));
		$data = array();
		$data['values'] = array('id' => $notification_id);
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = ''; 
		$data['items_source'] = $name.'/table/'.$notification_id; 
		$data['items_table'] = $this->_get_items('table');
		$data['content_view'] = "crud/table";
		$this->show_template('notifications/edit', $data);
	}
	
	public function table($notification_id)
	{
		$this->notification_id = $notification_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}
	
	function _callback_row($key, $item, &$rows)
	{
		switch ($key) {
			case 'id':
				$id = $item;
				$item = anchor('clients_repo/index/'.$id,'<i class="fa fa-book"></i> '.lang('docs_nots'), 'class="btn btn-success btn-sm"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}

	function _callback_filter()
	{
		return "notification_id=".$this->notification_id;
	}
	
}