<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Repo_docs extends MY_Controller {

	var $model = 'repo_docs_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-file-o';
		$this->create_title = lang('repo_docs_create');
	}
	
	function create($parent_id=NULL)
	{
		$this->repo_docs_m->set_category_id($parent_id);
		$parent_id = $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$data = $this->_create('repo/tree_panel/'.$parent_id, '#repo_tree_content');
		$this->load->view('crud/create', $data);
	}
	
	function edit($id)
	{
		$tree_id = 'd_'.$id;
		$data = $this->_edit($id, 'repo/tree_panel/'.$tree_id, '#repo_tree_content');
		$this->load->view('crud/edit', $data);
	}
	
	function delete($id)
	{
		$doc = $this->repo_docs_m->get_one($id);
		$cat_id = $doc['category_id']==NULL ? 'root' : 'c_'.$doc['category_id'];
		$data = $this->_delete($id, 'repo/tree_panel/d_'.$id, '#repo_tree_content', 'repo/tree_panel/'.$cat_id, FALSE);
		$this->load->view('crud/delete', $data);
	}
	
}