<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends MY_Controller {

	var $model = 'users_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-user';
		$this->main_title = lang('menu_users');
		$this->main_tip = lang('users_tip');
		$this->create_title = lang('users_create');
	}
	
	function index()
	{
		$this->_table(anchor('users/create','<i class="fa fa-plus"></i> '.lang('users_create'), 'class="btn btn-primary btn-sm"'));
	}
	
	function _callback_row($key, $item, &$rows)
	{
		switch ($key) {
			case 'main_manager':
				$item = $item==1 ? lang('yes') : lang('no');
				break;
			case 'image':
				$item = '<img src="'.site_url('uploader/view/avatar'.$item).'" style="display:block; margin:0 auto; border-radius: 50%; width: 50px; height: 50px;" alt="User Image">';
				break;
			case 'id':
				$id = $item;
				$item = anchor('users/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$item .= "&nbsp;"; 
				$item .= anchor('users/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}
}