//
//  DocsCategories.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 15/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import SwiftyJSON

class DocsCategories: NSObject {
    
    var itemNumber : Int?
    var itemId : String?
    var gotChilds : Bool?
    var categoryName : String?
    var shortDescription : String?
    var childs : String?
    var SubCategories : DocsSubCategories?
    var documents : DocumentObject?
    var subCategoriesArray = [DocsSubCategories]()
    var documentsArray = [DocumentObject]()
    var doctumentWithoutCategoryArray = [DocumentObject]()
    var docDict : JSON?
    
    init(jsonDictionary: Dictionary<String,JSON>, hasMenu: Bool, itemNumber:Int)
    {
        super.init()
        
        self.itemNumber = itemNumber
        
        if hasMenu == true
        {
            if itemNumber == 1
            {
                self.categoryName = "Personal Docs"
            }
            else if itemNumber == 2
            {
                self.categoryName = "General Docs"
            }
        }
        else
        {
            
        
            
            let arrayOfValues = Array(jsonDictionary.values)
            
            if(arrayOfValues.count != 0)
            {
                for var i =  0 ; i < arrayOfValues.count; i++
                {
                    let dict = arrayOfValues[i]
                    
                    self.categoryName = dict["category_name"].stringValue
                    debugPrint(self.categoryName)
                    self.itemId = dict["id"].stringValue
                    
                    if let docs = dict["docs"].array
                    {
                        for dicts in docs
                        {
                            self.documents = DocumentObject(jsonDictionary: dicts)
                            
                            self.documentsArray.append(self.documents!)
                        }
                    }
                    
                }
            }
            
            if let docWithoutCategory = jsonDictionary["docs"]?.array
            {
                self.categoryName = "Uncategorized"
                for dicts in docWithoutCategory
                {
                    self.documents = DocumentObject(jsonDictionary: dicts)
                    
                    self.doctumentWithoutCategoryArray.append(self.documents!)
                }
            }

            
            
          
            
        }
        
    }
    
    func documentGeneration()
    {
        
    }
    
    

}
