//
//  SubDocMenuViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 18/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Kingfisher

private let reuseIdentifier = "subDocMenuCell"

class SubDocMenuViewController: UIViewController, UICollectionViewDataSource, UICollectionViewDelegate, UIGestureRecognizerDelegate {
    
    var subDocsArray = [DocumentObject]()
    var docsCats : DocsCategoriesDemo?
    var document : DocumentObject?
    var userObss : userObject?
    var partnerShipss : String?
    var treeShows : String?
    var urlManagers : URLBaseManager?
    var brandInf : BrandingInfo?

    @IBOutlet weak var subDocMenuCollectionView: UICollectionView!
    
    
     func settingBrandingInfo() {
        
        
        brandInf = self.userObss?.partnerI?.brandInf
        
        if let brand = brandInf
        {
            
            self.view.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
            subDocMenuCollectionView.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
            
        }
        
    }
    
    override func viewWillAppear(animated: Bool) {
        
        super.viewWillAppear(animated)
        
        
        settingBrandingInfo()
        urlManagers = URLBaseManager.sharedInstance
        
        let logOutGestureLeft : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureLeft.direction = UISwipeGestureRecognizerDirection.Left
        self.view.addGestureRecognizer(logOutGestureLeft)
        
        let logOutGestureRight : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"backToMainMenu")
        logOutGestureRight.direction = UISwipeGestureRecognizerDirection.Right
        self.view.addGestureRecognizer(logOutGestureRight)
        
    }

    
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    
    func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        
        return 1
    }
    
    func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        var docNumber : Int?
        
        if self.treeShows == "Uncategorized"
        {
            if let docs = self.docsCats?.doctumentWithoutCategoryArray.count
            {
                docNumber = docs
            }
        }
            
        else
        {
            if let docs = self.docsCats?.documentsArray.count
            {
                docNumber = docs
            }
        }
        
        
        
        
        return docNumber!
        
    }
    
    
    
    func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell
    {
        
      let  docCell = collectionView.dequeueReusableCellWithReuseIdentifier(reuseIdentifier, forIndexPath: indexPath) as! SubDocMenuCollectionViewCell
        
        if self.treeShows == "Uncategorized"
        {
           self.document = self.docsCats?.doctumentWithoutCategoryArray[indexPath.row]
        }
        else
        {
            self.document = self.docsCats?.documentsArray[indexPath.row]
        }
        
        
        
        docCell.subDocMenuText.text = self.document?.shortDesc
        //docCell.subDocMenuImage.kf_setImageWithURL(getDocsImages((self.document?.docItemId)!), placeholderImage: nil)
        docCell.subDocMenuImage.kf_setImageWithURL(getDocsImages((self.document?.docItemId)!), placeholderImage: nil, optionsInfo: [.Options(KingfisherOptions.CacheMemoryOnly)])
        
        //kf_setImageWithURL(getDocsImages((self.docsCategoriesDemo?.itemId!)!), placeholderImage: UIImage(named: ""), optionsInfo: [.Options(KingfisherOptions.CacheMemoryOnly)])
        if let brand = brandInf
        {
            docCell.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
            docCell.subDocMenuText.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
        }
        
        return docCell
        
    }
    
    
    func getDocsImages(catDocId: String)->NSURL
    {
        
        let urlString  = "\((urlManagers?.DocumentImageURL)!)access_token=\((NSUserDefaults.init().objectForKey("token"))!)&item_id=\(catDocId)"
        let url = NSURL(string: urlString)
        debugPrint(urlString)
        return url!
    }
    
    
    
     func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        
        if self.treeShows == "Uncategorized"
        {
            self.document = self.docsCats?.doctumentWithoutCategoryArray[indexPath.row]
        }
        else
        {
            self.document = self.docsCats?.documentsArray[indexPath.row]
        }

        self.performSegueWithIdentifier("showDocumentSegue", sender: self)
        
    }
    
    
    
    
    // MARK: - Navigation
    
    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "showDocumentSegue"
        {
            let webDC = segue.destinationViewController as! WebViewController
            webDC.webURL = "\((urlManagers?.DocumentURL)!)access_token=\((NSUserDefaults.init().objectForKey("token"))!)&doc_id=\((self.document?.docItemId)!)"
            webDC.partner = self.partnerShipss!
            debugPrint(self.partnerShipss!)
            debugPrint(webDC.webURL)
        }
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    

}
