<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients extends MY_Controller {

	var $model = 'clients_m';
	var $edit_view  = 'clients/edit';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-smile-o';
		$this->main_title = lang('menu_clients');
		$this->main_tip = lang('clients_tip');
	}
	
	function index()
	{
		$this->_table();
	}
	
	function _callback_row($key, $item, &$rows){
	
		switch ($key) {
			case 'id':
				$id = $item;
				$item = '<a href="clients_repo/index/'.$id.'" id="document-'.$id.'" data-value="'.$id.'" class="btn btn-success btn-sm"><i class="fa fa-book"></i>'.lang('docs_nots').'</a>';
				//$item = anchor('clients_repo/index/'.$id,'<i class="fa fa-book"></i> '.lang('docs_nots'), 'class="btn btn-success btn-sm"');
				break;
			case 'isinvoice':
				if($item=='1'){
					$item='<input type="checkbox" onchange="invoicechecked('.$rows->id.',1);" checked="true" name="isinvoice" id="isinvoice-'.$rows->id.'" />';
				} else {
					$item='<input type="checkbox" onchange="invoicechecked('.$rows->id.',0);" name="isinvoice" id="isinvoice-'.$rows->id.'" />';
				}
				break;
		}
		 return $item===NULL? '' : $item; 
	}
	
	function invoice()
	{
		$id = $this->input->post('client_id');
		$this->load->model('clients_m');
		$isinvoice = $this->clients_m->checkclientinvoice($id);
		
		if($isinvoice > 0){
			$data['description'] = "Are you sure you need to delete it?";
		} else {
			$data['description'] = "Are you sure you need to create it?";
		}
		$data['clientid'] = $id;
		
		$this->load->view('clients/invoice-model',$data);
	}
	
	function clickedinvoice($id)
	{
		$this->load->model('clients_m');
		$isinvoice = $this->clients_m->clientinvoice($id);
		
		return $id;
	}
}