<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Docs_bundles extends MY_Controller {

	var $model = 'docs_bundles_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-th-large';
		$this->main_title = lang('menu_docs_bundles');
		$this->main_tip = lang('docs_bundles_tip');
		$this->create_title = lang('docs_bundles_create');
	}

	function index()
	{
		$this->_table(anchor('docs_bundles/create','<i class="fa fa-plus"></i> '.lang('docs_bundles_create'), 'class="btn btn-primary btn-sm"'));
	}

	function _callback_previous_row(&$row)
	{
		$item = anchor('docs_bundles/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
		$item .= "&nbsp;";
		$item .= anchor('docs_bundles/delete/'.$row->id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');

		$row->action = $item;
	}
	
	function get_repo_docs_list_by_bp($id){
		
		$this->load->model('docs_bundles_m');
		$rdlistdata = $this->docs_bundles_m->get_repo_docs_list_by_bp($id);
		
		echo json_encode($rdlistdata);
	}
}