<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends MY_Controller 
{
	
	function __construct()
	{	
		parent::__construct();
	}
		
	function index()
	{
		$this->form_validation->set_rules('user', lang('username'), 'callback__check_login');
		$this->_do_login();
		if ($this->form_validation->run() == FALSE){
			$this->load->view('templates/login', array('login_text' => $this->config->item('login_text')));
		}else{
			$this->_do_login();
		}
	}
	
	function logout()
	{
		$this->login_m->logout();
		redirect('login');
	}
	
	function _check_login($user)
	{
		$user_id = $this->login_m->login($user, $this->input->post('password'));
		if ($user_id!=NULL){
			return TRUE;
		}else{
			log_message('error', 'Login incorrect '.$user.":".$this->input->post('password'));
			$this->form_validation->set_message('_check_login', lang('login_incorrect'));
			return FALSE;
		}	
	}
	
	function _do_login()
	{
		if($this->login_m->is_loged_in())
		{
			redirect('/');
		}
	}
}