<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications extends MY_Controller {

	var $model = 'notifications_m';
	var $edit_view  = 'notifications/edit';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->edit_title = lang('notification_edit');
		$this->main_tip = lang('notifications_tip');
		$this->create_title = lang('notifications_create');
	}

	function index()
	{
		$this->_table(anchor('notifications/create','<i class="fa fa-plus"></i> '.lang('notifications_create'), 'class="btn btn-primary btn-sm"'));
	}
	
	function _callback_row($key, $item, &$rows){
		switch ($key) {
			case 'id':
				$id = $item;
				$item = anchor('notifications/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
				$item .= "&nbsp;"; 
				$item .= anchor('notifications/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');
				break;
		}
		 return $item===NULL? '' : $item; 
	}
	
}