<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MY_Controller extends CI_Controller {
    	
	protected $main_title;
	protected $main_tip;
	protected $icon;
	protected $model;
	protected $create_view = 'crud/create';
	protected $edit_view = 'crud/edit';
	protected $delete_view = 'crud/delete';
	protected $delete_title;
	protected $delete_msg;
	protected $create_title;
	protected $edit_title;
	private $breadcum = array();
	private $pre_breadcum = array();

    function __construct()
    {
        parent::__construct();
		
		$this->load->helper('url');
		$this->load->helper('form');
		$this->load->helper('language');
		$this->load->library('form_validation');
		$this->lang->load('app');
		$this->lang->load(APP_COMPANY_FORK);
		$this->load->model('login_m');
		$this->load->database();
		
		$this->create_title = lang('create_item');
		$this->edit_title = lang('edit_item');
		$this->delete_title = lang('delete_item');
		$this->delete_msg = lang('delete_msg');
		
		if(isset($this->model)){
			$this->load->model($this->model);
		}
		
		if(get_class($this) != 'Login' && get_class($this) != 'Ws' && get_class($this) != 'Uploader'){
			if(!$this->login_m->is_loged_in()){
				redirect('login');
			}
		}
    }
	
	function _set_rules($items = array())
	{
		foreach($items as $item)
		{
			if(!isset($item['type']) || ($item['type'] != 'p' && $item['type'] != 'h2' && $item['type'] != 'script' && $item['type'] != 'address_number'))
			{
				$field = $item['field'];
				if(isset($item['alias'])){
					$field = $item['alias'];
				}
				if(isset($item['type']) && $item['type']=='address'){
					if(stripos($item['rules'], 'required')!==FALSE){
						$add_rule = 'callback__addr_check['.$item['field'].','.$item['field_number'].',code,required]';
						$item['rules'] = str_ireplace('required', $add_rule, $item['rules']);
						$add_rule = 'callback__addr_check['.$item['field'].','.$item['field_number'].',addr,required]';
						$this->form_validation->set_rules($item['field'].'_addr', 'Dirección', $add_rule);
						$add_rule = 'callback__addr_check['.$item['field'].','.$item['field_number'].',cp,required]|numeric|exact_length[5]';
						$this->form_validation->set_rules($item['field'].'_cp', 'Código postal', $add_rule);
						$add_rule = 'callback__addr_check['.$item['field'].','.$item['field_number'].',number,required]|numeric|max_length[3]';
						$this->form_validation->set_rules($item['field_number'], 'Número', $add_rule);
					}else{
						$add_rule = 'callback__addr_check['.$item['field'].','.$item['field_number'].',no]';
						$item['rules'] = $item['rules'].'|'.$add_rule;
					}
				}
				if(!empty($item['rules'])){
					$this->form_validation->set_rules($field, $item['label'], $item['rules']);
				}else{
					$this->form_validation->set_rules($field, $item['label'], '');
				}
			}
		}
	}

	function _move_not_overwrite($source_file, $target_dir)
	{
		$source_name = basename($source_file);
		$target_file = $target_dir.$source_name;
		$count = 1;
		do{
			$exist = file_exists($target_file);
			if($exist == false){
				rename ($source_file, $target_file);
			}else{
				$source_name = $count.$source_name;
				$target_file = $target_dir.$source_name;
			}
			$count++;
		}while($exist == true);
		return '/'.$source_name;
	}
	
	function _get_data($items = array())
	{
		$data = array();
		foreach($items as $item)
		{
			if(isset($item['field']))
			{
				$field = $item['field'];
				$value = $this->input->post($field);
				$value = $value=='null'? NULL: $value;
				if(isset($item['type']) && isset($item['dir']) && $item['type'] == 'file' && preg_match('/^(\[#POOL#\])/',$value)===1) // && preg_match('"/^(\[#POOL#\])/"',$value)===1
				{
					$value = str_ireplace('[#POOL#]', '', $value);
					$value = $this->_move_not_overwrite(TEMP_UPLOAD.$value, BASE_UPLOAD.$item['dir'].'/');
				}
				if(isset($item['type']) && $item['type'] == 'date')
				{
					if(trim($value) == ""){
						$value = NULL;
					}else{						
						if(preg_match("/[0-9]{2}\/[0-9]{2}\/[0-9]{4}/", $value)){
							list($day, $month, $year) = explode('/', $value);
							$value = $year.'-'.$month.'-'.$day;
						}else{
							$value = date('Y-m-d', strtotime($value));
						}
					}
				}
				if(!isset($item['ignore']) || $item['ignore'] != TRUE)
				{
					$data[$field] = $value;
				}
			}
		}
		return $data;
	}
	
	function _delete_msg(&$data)
	{
		$data['msg'] = $this->delete_msg;
		$data['title'] = $this->delete_title;
	}
	
	function _create_msg(&$data)
	{
		$data['msg'] = '';
		$data['title'] = $this->create_title;
	}
	
	function _edit_msg(&$data)
	{
		$data['msg'] = '';
		$data['title'] = $this->edit_title;
	}
	
	function _get_fields($items = array(), $values=NULL, $view_only = FALSE)
	{
		$data = array();
		$view_suffix = '';
		if($view_only){
			$view_suffix = '_view';
		}
		foreach($items as $key=>$item)
		{
			if(isset($item['field']))
			{
				if(isset($values[$item['field']]))
				{
					if(!isset($item['type']) || $item['type']!='password')
					{
						$item['value'] = $values[$item['field']];
					}
					if(isset($item['type']) && $item['type']=='date'){
						$item['value'] = date('d/m/Y', strtotime($values[$item['field']]));
					}
				}
				$default_value = isset($item['value'])? $item['value'] : NULL;
				if($default_value==NULL){
					$value = set_value($item['field']);
				}else{
					$value = set_value($item['field'], $default_value);
				}
				$item['value'] = $value;
				if(!isset($item['type']))
				{
					$item['type'] = 'text';
				}
				if($item['type']=='address'){
					$this->load->model('address_m');
					
					$default_value = $this->address_m->get_addr($item['value']);
					$item['value_addr'] = set_value($item['field'].'_addr', $default_value);
					$default_value = $this->address_m->get_cp($item['value']);
					$item['value_cp'] = set_value($item['field'].'_cp', $default_value);
				}
				if($item['type']=='select_inline'){
					$item['items_table'] = Modules::run($item['module'].'/_get_items', $item['config']);
				}
				if(($item['type']=='select' || $item['type']=='multiselect_bd' || $item['type']=='multiselect' || $item['type']=='twolists') && !empty($item['model']) && !empty($item['method']))
				{
					$model = $item['model'];
					$method = $item['method'];
					$this->load->model($model);
					$params = array();
					if(isset($item['params'])){
						if(is_array($item['params'])){
							$params = $item['params'];
						}else{
							$params = array($item['params']);
						}
					}
					$item['values'] = call_user_func_array(array(&$this->$model,$method), $params);
				}
				$data_key = $item['field'];
			}else{
				$data_key = "item_".$key;
			}
			$data[$data_key] = $this->load->view('items/'.$item['type'].$view_suffix, array('item' => $item), TRUE);
		}
		return $data;
	}

	function create()
	{
		$name = strtolower(get_class($this));
		$data = $this->_create($name);
		$this->show_template($this->create_view, $data);
	}

	function _create($back='', $target='', $ok=NULL)
	{
		if($ok==NULL){$ok = $back;}
		$model = $this->model;
		$items = $this->_get_items('create');
		$this->_set_rules($items);
		$data = array();
        if($this->form_validation->run() == TRUE){
       		$data = $this->_get_data($items);
			$new_id = $this->$model->save(NULL, $data);
			$data['id'] = $new_id;
			if($new_id<=0){
				$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
				$data['status'] = 0;
			}else{
				$data['msg'] = 'Creado correctamente';
			}
        }else{
        	$data['fields'] = $this->_get_fields($items);
			$data['icon'] = $this->icon;
			$data['back'] = $back;
			$data['target'] = $target;
			$this->_create_msg($data);
        }
		if(isset($data['id'])){
			redirect($ok);
		}else{
			return $data;
		}
	}
	
	function edit($id)
	{
		$name = strtolower(get_class($this));
		$data = $this->_edit($id, $name);
		$this->show_template($this->edit_view, $data);
	}
	
	function _edit($id, $back='', $target='', $ok=NULL)
	{
		if($ok==NULL){$ok = $back;}
		$model = $this->model;
        $items = $this->_get_items('edit');
		$this->_set_rules($items);
		$data = array();
		if($this->form_validation->run() == TRUE){
			$data = $this->_get_data($items);
			$update_id = $this->$model->save($id, $data);
			$data['id'] = $update_id;
			if($update_id<=0){
				$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
				$data['status'] = 0;
			}else{
				$data['msg'] = 'Guardado correctamente';
			}
		}else{
			$data['values'] = $this->$model->get_one($id);
			$data['fields'] = $this->_get_fields($items, $data['values']);
			$data['icon'] = $this->icon;
			$data['back'] = $back;
			$data['target'] = $target;
			$this->_edit_msg($data);
		}
		if(isset($data['id'])){
			redirect($ok);
		}else{
			return $data;
		}
	}

	function delete($id)
	{
		$name = strtolower(get_class($this));
		$data = $this->_delete($id, $name);
		$this->show_template($this->delete_view, $data);
	}
	
	function _delete($id, $back='', $target='', $ok=NULL, $wrap=TRUE)
	{
		if($ok==NULL){$ok = $back;}
		$model = $this->model;
        $items = $this->_get_items('delete');
		$this->_set_rules($items);
		$data = array();
		if($this->form_validation->run() == TRUE){
			if($model == "clients_categories_m"){
				$checkinvoice = $this->$model->get_one($id);
				if($checkinvoice['isinvoice'] == "1"){
					$data['id'] = $id;
					$data['msg'] = 'You are not allow to delete it.';
				} else {
					$delete_id = $this->$model->delete($id);
					$data['id'] = $delete_id;
					if($delete_id<=0){
						$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
					}else{
						$data['msg'] = 'Borrado correctamente';
					}
				}
			} else if($model == "clients_docs_m"){
				$checkcategory = $this->$model->get_one($id);
				if($checkcategory['category_id'] != null && $checkcategory['category_id'] != ""){
					$this->load->model('clients_categories_m');
					$checkinvoice = $this->clients_categories_m->get_one($checkcategory['category_id']);
					if($checkinvoice['isinvoice'] == "1" && $checkinvoice['category_name'] == "Invoice"){
						$data['id'] = $id;
						$data['msg'] = 'You are not allow to delete it.';
					} else {
						$delete_id = $this->$model->delete($id);
						$data['id'] = $delete_id;
						if($delete_id<=0){
							$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
						}else{
							$data['msg'] = 'Borrado correctamente';
						}
					}
				} else {
					$delete_id = $this->$model->delete($id);
					$data['id'] = $delete_id;
					if($delete_id<=0){
						$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
					}else{
						$data['msg'] = 'Borrado correctamente';
					}
				}
			} else if($model == "repo_docs_m"){
				$this->load->model('clients_repo_docs_m');
				$checkrepodoc = $this->clients_repo_docs_m->get_by_repo_doc_id($id);
				if($checkrepodoc > 0){
					$clientsesbid = $this->clients_repo_docs_m->get_esb_by_repo_doc_id($id);
					$esbidslist = [];
					foreach($clientsesbid as $value){
						array_push($esbidslist,$value['external_id']);
					}
					$data['esbidslist'] = 'The following users have access to this document: ' . implode(", ",$esbidslist);
					$data['id'] = $id;
					$data['msg'] = 'This document can’t be deleted because it is available for at least one user.';
				} else {
					$delete_id = $this->$model->delete($id);
					$data['id'] = $delete_id;
					if($delete_id<=0){
						$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
					}else{
						$data['msg'] = 'Borrado correctamente';
					}
				}
			} else {
				$delete_id = $this->$model->delete($id);
				$data['id'] = $delete_id;
				if($delete_id<=0){
					$data['msg'] = 'Ha ocurrido un error pongase en contacto con el administrador';
				}else{
					$data['msg'] = 'Borrado correctamente';
				}
			}
		}else{
			
			if($model == "clients_categories_m"){
				$checkinvoice = $this->$model->get_one($id);
				if($checkinvoice['isinvoice'] == "1"){
					$this->delete_msg = "You are not allow to delete it.";
					//$data['title'] = $this->delete_title;
					$data['disabledelete'] = true;
				}
			} else if($model == "clients_docs_m"){
				$checkcategory = $this->$model->get_one($id);
				if($checkcategory['category_id'] != null && $checkcategory['category_id'] != ""){
					$this->load->model('clients_categories_m');
					$checkinvoice = $this->clients_categories_m->get_one($checkcategory['category_id']);
					if($checkinvoice['isinvoice'] == "1" && $checkinvoice['category_name'] == "Invoice"){
						$this->delete_msg = "You are not allow to delete it.";
						$data['disabledelete'] = true;
					}
				}
			} else if($model == "repo_docs_m"){
				$this->load->model('clients_repo_docs_m');
				$checkrepodoc = $this->clients_repo_docs_m->get_by_repo_doc_id($id);
				if($checkrepodoc > 0){
					$clientsesbid = $this->clients_repo_docs_m->get_esb_by_repo_doc_id($id);
					$esbidslist = [];
					foreach($clientsesbid as $value){
						array_push($esbidslist,$value['external_id']);
					}
					$data['esbidslist'] = 'The following users have access to this document: ' . implode(", ",$esbidslist);
					$this->delete_msg = "This document can’t be deleted because it is available for at least one user.";
					//$data['title'] = $this->delete_title;
					$data['disabledelete'] = true;
				}
			}
			
			$data['values'] = $this->$model->get_one($id);
			$data['fields'] = $this->_get_fields($items, $data['values']);
			$data['icon'] = $this->icon;
			$data['back'] = $back;
			$data['wrap'] = $wrap;
			$data['target'] = $target;
			$this->_delete_msg($data);
		}
		if(isset($data['id'])){
			redirect($ok);
		}else{
			return $data;
		}
	}
	
	function add_breadcum($url, $text)
	{
		$this->breadcum[] = array('url' => $url, 'text' => $text);
	}
	
	function add_pre_breadcum($url, $text)
	{
		$this->pre_breadcum[] = array('url' => $url, 'text' => $text);
	}
	
	private function get_breadcum()
	{
		$breadcum = array();
		$breadcum[] = array('url' => '', 'text' => '<i class="fa fa-home"></i>'.lang('menu_dashboard'));
		foreach($this->pre_breadcum as $key=>$item){
			$breadcum[] = $item;
		}
		if(lang('menu_dashboard') != $this->main_title){
			$breadcum[] = array('url' => strtolower(get_class($this)), 'text' => '<i class="'.$this->icon.'"></i> '.$this->main_title);
		}
		foreach($this->breadcum as $key=>$item){
			$breadcum[] = $item;
		}
		foreach($breadcum as $key=>$item){
			$breadcum[$key]['class'] = "";
		}
		$breadcum[(count($breadcum)-1)]['class'] = 'active';
		
		return $breadcum;
	}
	
	private function get_menu()
	{
		$this->config->load('app/menu');
		$menu = $this->config->item('main_menu');
		foreach($menu as $key=>$item){
			$menu[$key]['class'] = "";
			if($item['url']!=''){			
				if(preg_match('/^'.$item['url'].'/', $this->uri->uri_string())){
					$menu[$key]['class'] = "active";
				}
			}else{
				if($this->uri->uri_string() == ''){
					$menu[$key]['class'] = "active";
				}
			}
		}
		return $menu;
	}
	
	function show_template($view, $data = NULL, $template = 'templates/main')
	{
		if($data==NULL){$data = array();}
		$data['main_content'] = $view;
		$data['main_title'] = $this->main_title;
		$data['main_tip'] = $this->main_tip;
		$data['menu'] = $this->get_menu();
		$data['breadcum'] = $this->get_breadcum();
		$data['icon'] = $this->icon;
		$data['main_skin'] = $this->config->item('skin');
		$data['current_user'] = $this->login_m->get_user();
		$this->load->view($template, $data);
	}
	
	public function _table($toolbar='', $items_key='table')
	{
		$name = strtolower(get_class($this));
		$data = array();
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = $toolbar; 
		$data['items_source'] = $name.'/table'; 
		$data['items_table'] = $this->_get_items($items_key);
		$this->show_template('crud/table', $data);
	}
	
	public function _tree($content = NULL)
	{
		$name = strtolower(get_class($this));
		$data = array();
		$data['tree_id'] = $name."_tree"; 
		$data['tree_source'] = $name."/tree_source";
		$data['tree_panel'] = $name."/tree_panel";
		$data['tree_content'] = $content;
		$this->show_template('crud/tree', $data);
	}
	
	public function table()
	{
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}
	
	
	function _get_items($config)
	{
		if($config=='delete')
		{
			return array(
						array(
							'label' => 'confirmation',
							'field' => 'yes',
							'value' => "yes",
							'type' => 'hidden'
						)
					);
		}		
		$name = 'fields/'.strtolower(get_class($this));
		$this->config->load($name, TRUE, TRUE);
		$items = $this->config->item($config, $name);
		if(empty($items))
		{
			$items = $this->config->item($config);
			if(empty($items) || !is_array($items))
			{
				$items = array();
			}
		}
		$key_n = 0;
		foreach($items as $key=>$item){
			//var_dump($item);
			if($this->session->userdata('user_role') == 2 && strtolower(get_class($this)) == "docs_bundles"){
				if($item['field'] == "business_partner"){
					unset($items[$key]);
				}
			}
			if(isset($item['type']) && $item['type'] == 'password'){
				$repeat = $item['field'].'_repeat';
				$rules = 'matches['.$repeat.']';
				$rules_repeat = 'matches['.$item['field'].']';
				if(!empty($item['rules'])){
					$rules = $item['rules'].'|'.$rules;
					$rules_repeat = $item['rules'].'|'.$rules_repeat;
				}
				$items[$key]['rules'] = $rules;
				$item['field'] = $repeat;
				$item['rules'] = $rules_repeat;
				$item['label'] = 'Confirm '.$item['label'];
				$item['ignore'] = TRUE;
				$items = array_slice($items, 0, $key_n+1, true) +
						 array($item['field'] => $item) +
						 array_slice($items, $key_n+1, count($items) - 1, true);
			}
			$key_n++;
		}
		//$this->_dynamic_items($config, $items);
		return $items;
	}	
	
	function _ajax_table($items_key = 'table') 
	{
		$model = $this->model;
		if(empty($model)){return FALSE;}
		
		$items_table = $this->_get_items($items_key);
		
		/* 
		 * Paging
		 */
		$sOffset = 0;
		$sPagesize = 0;
		if ( isset( $_POST['iDisplayStart'] ) && $_POST['iDisplayLength'] != '-1' ) 
		{
			$sOffset = $_POST['iDisplayStart'];
			$sPagesize = $_POST['iDisplayLength'];
		}
		
		/*
		 * Ordering
		 */
		$sOrder = array();
		if ( isset( $_POST['iSortCol_0'] ) ) 
		{
			for ( $i=0 ; $i<intval( $_POST['iSortingCols'] ) ; $i++ ) 
			{
				if ( $_POST[ 'bSortable_'.intval($_POST['iSortCol_'.$i]) ] == "true" ) 
				{
					$value = $_POST['sSortDir_'.$i];
					$index = intval( $_POST['iSortCol_'.$i] );
					$name = $items_table[$index];
					if(isset($name['alias'])){
						$sOrder[$name['alias']] = $value;
					}else{
						$sOrder[$name['field']] = $value;
					}
					
				}
			}
		}
		
		/* 
		 * Filtering
		 * NOTE this does not match the built-in DataTables filtering which does it
		 * word by word on any field. It's possible to do here, but concerned about efficiency
		 * on very large tables, and MySQL's regex functionality is very limited
		 */
		$sLikeOR = array();
		if (isset($_POST['sSearch'])) 
		{
			$SearchString = $_POST['sSearch'];
		}else{
			$SearchString = "";
		}
		if ( $SearchString != "" ) 
		{
			foreach ($items_table as $item_table)
			{
				if(!isset($item_table['search']) || $item_table['search'] !== FALSE)
				{
					$sLikeOR[$item_table['field']] = $SearchString;
				}
			}
		}
		
		/* Individual column filtering */
		/*for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".mysqli_real_escape_string($_GET['sSearch_'.$i])."%' ";
			}
		}*/
		
		$filter = $this->_callback_filter();
		
		$TotalRecords = $this->$model->read_table($items_table, array(), array(), 0, 0, TRUE, $filter);
		$DisplayRecords = $this->$model->read_table($items_table, $sLikeOR, array(), 0, 0, TRUE, $filter);											
		$data_table = $this->$model->read_table($items_table, $sLikeOR, $sOrder, $sPagesize, $sOffset, FALSE, $filter);
  
		$aaData = array();
		foreach($data_table as $rows)
		{   
			if(method_exists($this, "_callback_previous_row")){
				$this->_callback_previous_row($rows);
			}
				
			$row = array();
			foreach($rows as $key=>$item)
			{
				$ret_row = $this->_callback_row($key, $item, $rows);
				if($ret_row!==NULL)
				{
					$row[] = $ret_row;	
				}
			}
			$aaData[] = $row;
		}
		
		$json_table = array ('sEcho' => intval($this->input->post('sEcho')),
						'iTotalRecords'	=> $TotalRecords,
						'iTotalDisplayRecords' => $DisplayRecords,
						'aaData' => $aaData);
		
		return $json_table;
	}

	function _callback_filter(){}
	
	function _callback_row($key, $item, &$rows){ return $item===NULL? '' : $item; }
	
}