<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MY_Model extends CI_Model {

	protected $primary_key = 'id';
	protected $table = NULL;
	protected $items = array();

    function __construct()
    {
        parent::__construct();
	}
	
	function get_one($id)
	{
		$this->db->select('*, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key);
		$this->db->where($this->table.'.'.$this->primary_key, $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		$data = $this->_get_virtuals($id, $data);
		return $data;
	}
	
	function get_all()
	{
		$query = $this->db->get($this->table);
		return $query->result_array();
	}
	
	function get_select($text_field, $filter=NULL)
	{
		if(!empty($filter)){
			$this->db->where($filter);
		}
		$this->db->select($this->table.'.'.$this->primary_key.' as value', FALSE);
		$this->db->select($text_field.' as text', FALSE);
		$this->db->order_by($this->primary_key);
		$query = $this->db->get($this->table);
		$result = $query->result_array();
		return $result;
	}

	function _get_virtuals($id, $data)
	{
		return $data;
	}
	
	function save($id=null, $data)
	{
		$this->_before_save($id, $data);
		if(empty($id)){
			return $this->insert($data);
		}else{
			return $this->update($id, $data);
		}
	}
	
	function _before_save($id, &$data){
		if ($this->table == "repo_categories") {
            $data['admin_id'] = $this->session->userdata('manager');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
		
		if ($this->table == "clients_categories") {
            $data['admin_id'] = $this->session->userdata('manager');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
		
		if ($this->table == "repo_docs") {
            $data['admin_id'] = $this->session->userdata('manager');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
		
		if ($this->table == "clients_docs") {
            $data['admin_id'] = $this->session->userdata('manager');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
		
		if ($this->table == "notifications") {
            $data['admin_id'] = $this->session->userdata('manager');
            $data['updated_at'] = date('Y-m-d H:i:s');
        }
	}
	
	function _before_insert(&$data){
		
	}
	
	function insert($data)
	{
		$this->_before_insert($data);
		$this->db->insert($this->table, $data);
		$id = $this->db->insert_id();
		
		$this->_after_insert($id);
		$this->_after_save($id);
		return $id;
	}
	
	function _before_update($id, &$data){
		
	}
	
	function update($id, $data)
	{
		$this->_before_update($id, $data);
		$this->db->where($this->primary_key, $id);
		$this->db->update($this->table, $data);
		$affected_rows = $this->db->affected_rows();
		if($affected_rows==0){
			$item = $this->get_one($id);
			$distinct = FALSE;
			foreach($data as $name=>$value){
				if(!isset($item[$name]) || $item[$name]!=$value){
					$distinct = TRUE;
					break;
				}
			}
			if($distinct){
				$id = 0;
			}
		}
		$ret1 = $this->_after_update($id);
		$ret2 = $this->_after_save($id);
		return ($ret1===false || $ret2===false) ? false : $id;
	}


	function _after_insert($id)
	{
		
	}
	
	function _after_update($id)
	{
		
	}
	
	function _after_save($id)
	{
		
	}
	
    function affected_rows() {
        $affected_rows = $this->db->affected_rows();
        return $affected_rows;
    }
    
	function delete($id)
	{
		$this->_before_delete($id);
		
		$this->db->where($this->primary_key ,$id);
		$this->db->delete($this->table);
		$affected_rows = $this->db->affected_rows();
		$this->_after_delete();
        return $affected_rows;
	}
	
	function _after_delete(){
		
	}
	
	function _before_delete($id)
	{
		
	}
	
	function _callback_table()
	{
		
	}
	
	function read_table($items, $or_like=array(), $order=array(), $Pagesize=0, $Offset=0, $count=FALSE, $filter=NULL) {
		$this->db->from($this->table);
		$this->_callback_table();
		
		foreach($items as $key=>$item){
			if(!isset($item['field'])){
				unset($items[$key]);
			}	
		}
		
		if(!$count){
			foreach ($items as $item){
				if(!isset($item['alias'])){
					$this->db->select($item['field'], TRUE);
				}else{
					$this->db->select($item['field'].' AS '.$item['alias'], FALSE);
				}
			}
		}else{
			$this->db->select('count('.$this->table.'.'.$this->primary_key.') AS total', FALSE);
		}
		
		$where = "";
        if (!empty($or_like)) {
		foreach ($or_like as $column=>$string){
			$wildcard = "%";
			if (strpos($string,'*') !== false || strpos($string,'?') !== false) {
				$string=str_replace('*','%',$string);
				$string=str_replace('?','_',$string);
				$wildcard = "";
			}
			if(!empty($filter)){
				$where .= " OR (".$filter." AND LOWER(".$column.") LIKE LOWER('".$this->db->escape_str($wildcard.$string.$wildcard)."'))";
			}else{
				$where .= " OR (LOWER(".$column.") LIKE LOWER('".$this->db->escape_str($wildcard.$string.$wildcard)."'))";
			}
		}
        }
		if(!empty($where)){
			$this->db->where("TRUE = FALSE ".$where, NULL, FALSE);
		}else{
			if(!empty($filter)){
				$this->db->where($filter, NULL, FALSE);
			}
		}
		foreach ($order as $column=>$direction){
			$this->db->order_by($column, $direction);
		}
			
		if(!$count){
			if ($Pagesize!=0){
				$this->db->limit($Pagesize, $Offset);
			}
		}
			
		$query = $this->db->get();
		if($count){
			$num_rows = $query->num_rows();
			if ($num_rows > 0){
				$row = $query->row_array();
				if($num_rows==1){
					return $row['total'];
				}else{
					return $num_rows;
				}				
			}else{
				return 0;
			}
		}else{
			if ($query->num_rows() > 0) {
				return $query->result();
			}else{
				return array();
			}
		}
	}
	
}