<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Docs_bundles_m extends MY_Model {
	
	var $table = "docs_bundles";
	var $cust_save_data_copy;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function _callback_table()
	{
		if($this->session->userdata('user_role') == 2){
			$this->db->where('docs_bundles.business_partner',$this->session->userdata('business_partner'));
		}
	}
	
	function get_repo_docs_list(){
		
		if($this->session->userdata('user_role') == 2){
			$this->db->select(array('id','name'));
			$this->db->where('business_partner',$this->session->userdata('business_partner'));
			$this->db->distinct();
			$query = $this->db->get('repo_docs');
		} else {
			$this->db->select(array('id','name'));
			$this->db->distinct();
			$query = $this->db->get('repo_docs');
		}

		$list = [];
		foreach($query->result_array() as $data){
			$list[] = [
				'value' => $data['id'],
				'text' => $data['name'],
			];
		}

		return $list;
	}
	
	function get_repo_docs_list_by_bp($bp){
		
		$this->db->select(array('id','name'));
		$this->db->where('business_partner',$bp);
		$this->db->distinct();
		$query = $this->db->get('repo_docs');
		

		$list = [];
		foreach($query->result_array() as $data){
			$list[] = [
				'value' => $data['id'],
				'text' => $data['name'],
			];
		}
		return $list;
	}
	
	function _before_save($id, &$data)
	{
		$this->cust_save_data_copy = $data;
		unset($data['repo_doc_id']);
		if ($this->table == "docs_bundles" && $this->session->userdata['user_role'] == 2) {
            $data['business_partner'] = $this->session->userdata['business_partner'];
        }
	}
		
	function _after_save($id)
	{
		if ($this->table == "docs_bundles") {
			$this->set_repo_docs_to_bundle($id, $this->cust_save_data_copy['repo_doc_id']);
		}
	}
	
	function set_repo_docs_to_bundle($id,$repo_docs_array){
		
		$this->db->select('repo_doc_id');
		$this->db->from('docs_bundles_repo_docs');
		$this->db->where('docs_bundles_id', $id );
		$query1 = $this->db->get();
		$result_array1 = $query1->result_array();
		
		if(count($result_array1) > 0){
			
			$repo_doc_ids = [];
			
			foreach($result_array1 as $data){
				array_push($repo_doc_ids,$data['repo_doc_id']);
			}
			
			if(!$repo_docs_array){
				$repo_docs_array = [];
			}
			
			$diff_ids = array_intersect($repo_doc_ids,$repo_docs_array);
			
			$new_insert_ids = array_diff($repo_docs_array,$diff_ids);
			$del_insert_ids = array_diff($repo_doc_ids,$diff_ids);
			
			if(count($del_insert_ids) > 0){	
				foreach($del_insert_ids as $value){
					$this->db->where('repo_doc_id', $value);
					$this->db->delete("docs_bundles_repo_docs");
				}
			}
			if(count($new_insert_ids) > 0){
				foreach($new_insert_ids as $value){
					$this->db->insert("docs_bundles_repo_docs", ["docs_bundles_id" => $id, "repo_doc_id" => $value]);
					$cust_id = $this->db->insert_id();
				}
			}
			
		} else {
			foreach($repo_docs_array as $value){
				
				$this->db->insert("docs_bundles_repo_docs", ["docs_bundles_id" => $id, "repo_doc_id" => $value]);
				$cust_id = $this->db->insert_id();
			}
		}		
		return true;
	}
}	