<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Repo_docs_m extends MY_Model {
	
	var $table = "repo_docs";
	private $category_id;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_cats_branch($doc_id)
	{
		$doc = $this->get_one($doc_id);
		if(isset($doc['category_id'])){
			$this->load->model('repo_categories_m');
			return $this->repo_categories_m->get_cats_branch($doc['category_id']);
		}
		return array();
	}
	
	function set_category_id($category_id)
	{
		$this->category_id = $category_id;
	}
	
	private function save_model_data(&$data)
	{
		if(isset($this->category_id) && !isset($data['category_id'])){
			$data['category_id'] = $this->category_id;
		}
	}
	
	function _before_insert(&$data)
	{
		$this->save_model_data($data);
	}
	
	function _before_update($id, &$data)
	{
		$this->save_model_data($data);
	}
	
	function get_by_category_id($cat_id=NULL)
	{
		if($cat_id==NULL){
			$this->db->where('category_id IS null');
		}else{
			$this->db->where('category_id', $cat_id);
		}
		
		if($this->session->userdata('user_role') == 2){
			$this->db->where('business_partner', $this->session->userdata('business_partner'));
		}
		
		return $this->get_all();
	}
	
	function get_by_doc_id($id)
	{
		$this->db->where('doc_id', $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		return $data;
	}
	
	function get_filtered_by_category_id($docs_ids, $category_id=NULL)
	{
		if(empty($docs_ids)){return array();}
		$this->db->where_in('id', $docs_ids);
		if($category_id==NULL){
			$this->db->where('category_id IS null');
		}else{
			$this->db->where('category_id', $category_id);
		}
		return $this->get_all();
	}
	
	function get_custom_one($id)
	{
		$this->db->join('admin', 'admin.id = '.$this->table.'.admin_id', 'left outer'); 
		$this->db->select($this->table.'.*, admin.user as user, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key);
		$this->db->where($this->table.'.'.$this->primary_key, $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		$data = $this->_get_virtuals($id, $data);
		return $data;
	}
	
	function checkrepodocumentbydocid($doc_ID){
		$this->db->where('doc_id', $doc_ID);
		$query = $this->db->get($this->table);
		$rowcount = $query->num_rows();
		return $rowcount;
	}
	
	function setrepodocument($dataArray){
		$this->db->insert($this->table, $dataArray);
		return $this->db->insert_id();
	}
	
	function updaterepodocument($doc_ID, $dataArray){
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 0");
		
        $this->db->where('doc_id', $doc_ID);
		$this->db->update($this->table, $dataArray);
		$rows_cnt =  $this->db->affected_rows();
		
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 1");
		return $rows_cnt;
	}
	
	function deleterepodocument($doc_ID){
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 0");
		
		$this->db->where('doc_id', $doc_ID);
		$this->db->delete($this->table);
		$rows_cnt = $this->db->affected_rows();
		
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 1");
		return $rows_cnt;
	}
}