<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users_bpartner_m extends MY_Model {
	
	var $table = "users_bpartner";
	var $save_data_copy;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_by_business_partner_id($id)
	{
		$this->db->select('user_id');
		$this->db->from('users_bpartner');
		$this->db->where('business_partner', $id );
		$query1 = $this->db->get();
		
		return $query1->result_array();
	}

	function custom_insert_data($id, $bpartarray)
	{
		$this->db->select('business_partner');
		$this->db->from('users_bpartner');
		$this->db->where('user_id', $id );
		$query1 = $this->db->get();
		$result_array1 = $query1->result_array();
		
		if(count($result_array1) > 0){
			
			$user_bpartners = [];
			
			foreach($result_array1 as $data){
				array_push($user_bpartners,$data['business_partner']);
			}
			
			if(!$bpartarray){
				$bpartarray = [];
			}
			
			$diff_ids = array_intersect($user_bpartners,$bpartarray);
			
			$new_insert_ids = array_diff($bpartarray,$diff_ids);
			$del_insert_ids = array_diff($user_bpartners,$diff_ids);
			
			if(count($del_insert_ids) > 0){	
				foreach($del_insert_ids as $value){
					$this->db->where('business_partner', $value);
					$this->db->delete($this->table);
				}
			}
			if(count($new_insert_ids) > 0){
				foreach($new_insert_ids as $value){
					$this->db->insert($this->table, ["user_id" => $id, "business_partner" => $value]);
				$cust_id = $this->db->insert_id();
				}
			}
			
		} else {
			foreach($bpartarray as $value){
				
				$this->db->insert($this->table, ["user_id" => $id, "business_partner" => $value]);
				$cust_id = $this->db->insert_id();
			}
		}		
		return true;
	}
	
	function custom_delete_data($id){
		
		$this->db->where('user_id', $id);
		$this->db->delete($this->table);
		
		return true;
	}
}