//
//  ContainerObject.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 20/10/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import SwiftyJSON
import Foundation


class ContainerObject: NSObject {
    
    var active: Int?
    var usable: Int?
    var identifier: Int?
    var imageURL: String?
    var name: String?
    var typeOfContainer: String?
    var service: ServiceObject?
    var category : CategoryObject?
    var subServiceArray : NSMutableArray?
    var smartImage: String?
    
    
    init(jsonDictionary: JSON , typeOfContainer: String)
    {
        super.init()
        
        self.typeOfContainer = typeOfContainer
        
        if typeOfContainer == "category"
        {
        
            self.category = CategoryObject.init(jsonDictionary: jsonDictionary)
            
        self.active = self.category?.active
        self.identifier = self.category?.categoryId
        self.imageURL = self.category?.imageURL
        self.name = self.category?.name
        self.smartImage = self.category?.smartImage
            
            
        }
        
        else if typeOfContainer == "service"
        {
            self.service = ServiceObject.init(jsonDictionary: jsonDictionary)
            
            self.name = self.service?.name
            self.imageURL = self.service?.image
            self.identifier = self.service?.categoryId
            self.active = self.service?.active
            self.usable = self.service?.usable
            self.smartImage = self.service?.smartImage
        }
        
        
        
        
    }


}
