//
//  LoginViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 16/10/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Alamofire
import SwiftyJSON

class LoginViewController: UIViewController, UITextFieldDelegate {
    
    @IBOutlet weak var logoPartner: UIImageView!
    
    @IBOutlet weak var contenScrollView: UIView!
    
    @IBOutlet weak var scrollView: UIScrollView!

    /** outlets*/
    @IBOutlet weak var userNameTextField: UITextField!
    
    @IBOutlet weak var passwordTextField: UITextField!
    
    @IBOutlet weak var logInButton: UIButton!
    
    var userOb: userObject?
    
    var partner: String?
    
    var releaseM : ReleaseManager?
    
    var urlManager : URLBaseManager?
    
    @IBAction func hiddenButton(sender: AnyObject) {
        
        self.dismissViewControllerAnimated(true, completion: nil)
    }
    
    @IBAction func logInAction(sender: AnyObject) {
     
       if Reachability.isConnectedToNetwork() == true
       {
        
            if logInButton.titleLabel?.text == "Log In"
            {
        
                let user: String = self.userNameTextField.text!
                let password : String  = self.passwordTextField.text!
            
                loginMethod(user, password:password)
            
            }
            else
            {
                let user: String = (releaseM?.appDemo!)!
                let password : String  = (releaseM?.appDemo!)!
            
                loginMethod(user, password:password)
            }
        }
        else
       {
        
            self.alertMessage()
        
        }
        
        
        
    
    }
    
    func loginMethod(user: String, password: String)
    {
        
        
            Alamofire.request(.POST, (urlManager?.LoginURL)! , parameters: ["email":user,"password":password,"source":"Mobile"])
                
                .responseJSON { response in
                    print(response.request)  // original URL request
                    print(response.response) // URL response
                    print(response.data)     // server data
                    print(response.result)   // result of response serialization
                    
                    if let _ = response.result.value {
                        
                        let json = JSON(data: response.data!)
                        debugPrint(json, terminator: "")
                        
                        self.userOb = userObject.init(jsonDictionary: json)
                        
                        if  self.userOb?.availableServices?.count > 0
                        {
                            self.canLogIn()
                        }
                        else
                        {
                            self.alertMessage()
                        }
                        
                    }
                    else
                    {
                        
                    }
            }
            
        
       
    }
    
    func baseURLError()
    {
        dispatch_async(dispatch_get_main_queue()) {
            
            let alert = UIAlertController(title: "Base URL not found", message: "Please, check internet connectivity", preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title: "Ok", style: UIAlertActionStyle.Default, handler: { (UIAlertAction) -> Void in
                alert.dismissViewControllerAnimated(true, completion: nil)
            }))
            
            self.presentViewController(alert, animated: true, completion: nil)
            
        }
    }

    
    func wrongCredentials()
    {
        dispatch_async(dispatch_get_main_queue()) {
            
            let alert = UIAlertController(title: "The credentials you entered did not match our records", message: "Please, introduce the right crendentials in order to log in", preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title: "Ok", style: UIAlertActionStyle.Default, handler: { (UIAlertAction) -> Void in
                alert.dismissViewControllerAnimated(true, completion: nil)
            }))
           
            self.presentViewController(alert, animated: true, completion: nil)
            
        }
    }
    
    func alertMessage()
    {
        dispatch_async(dispatch_get_main_queue()) {
            
            let alert = UIAlertController(title: "There are no services available", message: "Please, try again later", preferredStyle: UIAlertControllerStyle.Alert)
            alert.addAction(UIAlertAction(title: "Ok", style: UIAlertActionStyle.Default, handler: { (UIAlertAction) -> Void in
                alert.dismissViewControllerAnimated(true, completion: nil)
            }))
            
            self.presentViewController(alert, animated: true, completion: nil)
            
        }
    }
    
    func settingPartnersColor()
    {
        self.logInButton.setTitle("Enter Without Login", forState: UIControlState.Normal)
        
        if let name = self.partner
        {
           
           releaseM = ReleaseManager(initWithPartner: name)
           urlManager = URLBaseManager.sharedInstance

            logInButton.backgroundColor = releaseM?.color
            logoPartner.image = UIImage(imageLiteral: (releaseM?.logo)!)
        }
        
        
        
    }
    
    override func viewWillAppear(animated: Bool) {
        
        super.viewWillAppear(animated)
        
        //Settings the partner´s color
        settingPartnersColor()
        
        self.userNameTextField.text = ""
        self.passwordTextField.text = ""
        
         NSNotificationCenter.defaultCenter().addObserver(self, selector: "wrongCredentials", name: "urlError", object: nil)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "keyboardWillShowNotification:", name: UIKeyboardWillShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "keyboardWillHideNotification:", name: UIKeyboardWillHideNotification, object: nil)
        NSNotificationCenter.defaultCenter().addObserver(self, selector: "wrongCredentials", name: "wrongLogin", object: nil)
        //NSNotificationCenter.defaultCenter().addObserver(self, selector: "canLogIn", name: "successLog", object: nil)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        
               // Do any additional setup after loading the view.
    }
    
    override func viewDidDisappear(animated: Bool) {
        super.viewDidDisappear(animated)
        
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardWillShowNotification, object: nil)
        NSNotificationCenter.defaultCenter().removeObserver(self, name: UIKeyboardWillHideNotification, object: nil)

        
    }
    
    func canLogIn()
    {

        self.performSegueWithIdentifier("mainMenuSegue", sender: self)
        
    }

    // MARK: - Notifications
    
    func keyboardWillShowNotification(notification: NSNotification) {
        
        dispatch_async(dispatch_get_main_queue()) {
            
            UIView.animateWithDuration(0.5, animations: { () -> Void in
                 self.scrollView.setContentOffset(CGPointMake(0, 250), animated: true)
            })
        
        }
        
    }
    
    func keyboardWillHideNotification(notification: NSNotification) {
        
        dispatch_async(dispatch_get_main_queue()) {
            
            UIView.animateWithDuration(0.5, animations: { () -> Void in
                self.scrollView.setContentOffset(CGPointMake(0, 0), animated: true)
            })
            
        }

        
    }
    
    
    // MARK: - Private
    
    

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
    func textFieldShouldEndEditing(textField: UITextField) -> Bool {
        
        if (textField == self.userNameTextField)
        {
            
            self.userNameTextField.resignFirstResponder()
            
            if (self.userNameTextField.text?.length>0)
            {
                    self.logInButton.setTitle("Log In", forState: UIControlState.Normal)
            }
        }
        else if (textField == self.passwordTextField)
        {
            self.passwordTextField.resignFirstResponder()
            
            if(self.passwordTextField.text?.length>0)
            {
                 self.logInButton.setTitle("Log In", forState: UIControlState.Normal)
            }
        }
        
        return true
    }
    
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        
        if textField == self.userNameTextField
        {
            self.userNameTextField.resignFirstResponder()
        }
        else if textField == self.passwordTextField
        {
            self.passwordTextField.resignFirstResponder()
        }
        
        return true
    }

    
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "mainMenuSegue"
        {
            let MainVC = segue.destinationViewController as! MainMenuViewController
            MainVC.partner = self.partner
            MainVC.user = self.userOb
            debugPrint((self.userOb?.availableServices?.count)!)
            
            
        }
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    
}
