//
//  MainMenuViewController.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 21/10/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit
import Kingfisher
import Alamofire
import SwiftyJSON

class MainMenuViewController: UIViewController, UICollectionViewDataSource, UICollectionViewDelegate, UIGestureRecognizerDelegate {

    var availableServices : NSMutableArray = NSMutableArray()
    var  user: userObject?
    var container : ContainerObject?
    var serviceCell : serviceCollectionViewCell?
    var partner: String?
    var brandInf : BrandingInfo?
    var releaseM : ReleaseManager?
    var contact : ContactObject?
    var urlManager : URLBaseManager?
    
   // var menuTreeArray = [DocsCategories]()
   // var repotreeArray = [DocsCategories]()
   // var usertreeArray = [DocsCategories]()
   // var docsCategories : DocsCategories?
    var docsCategoriesDemo : DocsCategoriesDemo?
     var menuTreeArray = [DocsCategoriesDemo]()
     var repotreeArray = [DocsCategoriesDemo]()
     var usertreeArray = [DocsCategoriesDemo]()
    @IBOutlet weak var collectionView: UICollectionView!
   
    
    func settingBrandingInfo()
    {
        if let name = self.partner
        {
            releaseM = ReleaseManager(initWithPartner: name)
            brandInf = self.user?.partnerI?.brandInf
            
            if let brand = brandInf
            {
               
               self.view.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
                debugPrint(Float(brand.topColorArray[0]),Float(brand.topColorArray[1]),Float(brand.topColorArray[2]))
                collectionView.backgroundColor = UIColor(colorLiteralRed: Float(brand.topColorArray[0])/255, green: Float(brand.topColorArray[1])/255, blue: Float(brand.topColorArray[2])/255, alpha: 1.0)
                
            }
            
                
        }

    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        
        self.menuTreeArray.removeAll()
        self.usertreeArray.removeAll()
        self.repotreeArray.removeAll()
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        settingBrandingInfo()
        urlManager = URLBaseManager.sharedInstance
        
        let logOutGestureLeft : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"logOut")
        logOutGestureLeft.direction = UISwipeGestureRecognizerDirection.Left
        self.view.addGestureRecognizer(logOutGestureLeft)
        
        let logOutGestureRight : UISwipeGestureRecognizer = UISwipeGestureRecognizer(target: self, action:"logOut")
        logOutGestureRight.direction = UISwipeGestureRecognizerDirection.Right
        self.view.addGestureRecognizer(logOutGestureRight)
        
        
    
        // Do any additional setup after loading the view.
    }

    override func viewDidDisappear(animated: Bool) {
        super.viewDidDisappear(animated)
        
        self.serviceCell = nil
        collectionView = nil
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    func logOut()
    {
        Alamofire.request(.GET, LogOutURL)
            
            .responseJSON { response in
                print(response.request)  // original URL request
                print(response.response) // URL response
                print(response.data)     // server data
                print(response.result)   // result of response serialization
                  if let _ = response.result.value {
                    
                    self.dismissViewControllerAnimated(true, completion: nil)
                }
            }

    }
    
    // UICollectionView Delegates and DataSource
    
    
    
    func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        
        return 1
    }
    
    func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        
        let count: Int = (self.user?.availableServices?.count)!
        debugPrint(count)
        return count
        
    }
    
    
    
     func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell {
        

        
        self.user?.container = self.user?.availableServices?.objectAtIndex(indexPath.row) as? ContainerObject
        debugPrint(self.user?.container?.typeOfContainer)
        debugPrint(self.user?.container?.name)
        
        if self.user?.container?.typeOfContainer == "service"
        {
          
            self.serviceCell = collectionView.dequeueReusableCellWithReuseIdentifier("serviceCell", forIndexPath: indexPath) as? serviceCollectionViewCell
            self.serviceCell?.serviceLabel?.text = self.user?.container?.name
            self.serviceCell?.serviceImage.kf_setImageWithURL(NSURL(string: (self.user?.container?.smartImage)! as String)!, placeholderImage: UIImage(named: ""), optionsInfo:[.Options(KingfisherOptions.CacheMemoryOnly)])
            debugPrint((self.user?.container?.smartImage)!)
           
            
            if let brand = brandInf
            {
                
                self.serviceCell!.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
                debugPrint(Float(brand.colorServiceArray[0]),Float(brand.colorServiceArray[1]),Float(brand.colorServiceArray[2]))
                debugPrint(Float(brand.colorServiceArray[0])/255,Float(brand.colorServiceArray[1])/255,Float(brand.colorServiceArray[2])/255)
                self.serviceCell?.serviceLabel.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
                
                
            }
        
        }
        else if self.user?.container?.typeOfContainer == "category"
        {
            
            
            self.serviceCell = collectionView.dequeueReusableCellWithReuseIdentifier("serviceCell", forIndexPath: indexPath) as? serviceCollectionViewCell
            self.serviceCell?.serviceLabel?.text = self.user?.container?.name
            self.serviceCell?.serviceImage.kf_setImageWithURL(NSURL(string: (self.user?.container?.smartImage)! as String)!, placeholderImage: UIImage(named: ""), optionsInfo:[.Options(KingfisherOptions.CacheMemoryOnly)])
            debugPrint((self.user?.container?.smartImage)!)
            
            if let brand = brandInf
            {
                
                self.serviceCell!.backgroundColor = UIColor(colorLiteralRed: Float(brand.colorServiceArray[0])/255, green: Float(brand.colorServiceArray[1])/255, blue: Float(brand.colorServiceArray[2])/255, alpha: 1.0)
                
                self.serviceCell?.serviceLabel.textColor = UIColor(colorLiteralRed: Float(brand.fontColorService[0])/255, green: Float(brand.fontColorService[1])/255, blue: Float(brand.fontColorService[2])/255, alpha: 1.0)
                
                
            }
        
        }
        
        return serviceCell!
        
        
    }
    

    
    
   
     func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        
        
        self.user?.container = self.user?.availableServices?.objectAtIndex(indexPath.row) as? ContainerObject
        
        if self.user?.container?.typeOfContainer == "service"
        {
           if let typeOfService  = self.user?.container?.service?.type
           {
              typeOfServices(typeOfService)
              debugPrint(typeOfService)
           }
           
        
        }
        else
        {
             if let typeOfCategory : Int = (self.user?.container?.category?.categoryId)!
             {
                typeOfCategories(typeOfCategory)
                
              }
            
        }
        
        
    }
    
// MARK: - Native Service Creation
    
    func docmanCreation()
    {
        Alamofire.request(.POST, (urlManager?.DocumentsURL)!, parameters: ["access_token":NSUserDefaults.init().objectForKey("token")!])
            
            .responseJSON { response in
                print(response.request)  // original URL request
                print(response.response) // URL response
                print(response.data)     // server data
                print(response.result)   // result of response serialization
                
                if let _ = response.result.value {
                    
                    let json = JSON(data: response.data!)
                    debugPrint(json, terminator: "")
                    
        
                    
                    if let repoDict = json["repotree"].array
                    {
                        for dict in repoDict
                        {
                            
                            self.docsCategoriesDemo = DocsCategoriesDemo(jsonDictionary: dict, hasMenu: false, itemNumber: 0)
                            self.repotreeArray.append(self.docsCategoriesDemo!)
                        }
                    }
                    
                    if  let userDict = json["usertree"].array
                    {
                        
                        for dict in userDict
                        {
                           
                            self.docsCategoriesDemo = DocsCategoriesDemo(jsonDictionary: dict, hasMenu: false, itemNumber: 0)
                            self.usertreeArray.append(self.docsCategoriesDemo!)
                        }
                        
                    }
                    
                    if (self.usertreeArray.count > 0 && self.repotreeArray.count > 0)
                    {
                        //let dumiDict = [String:JSON]()
                        for (var i : Int = 1; i <= 2 ; i++)
                        {
                            self.docsCategoriesDemo = DocsCategoriesDemo(jsonDictionary: nil, hasMenu: true, itemNumber: i)
                            self.menuTreeArray.append(self.docsCategoriesDemo!)
                        }
                        debugPrint(self.menuTreeArray.count)
                        self.performSegueWithIdentifier("menuDocSegue", sender: self)
                        
                    }
                    else
                    {
                       // self.performSegueWithIdentifier("docSegue", sender: self)
                    }
                    
                    
                    /*
        
                    if  let repoDict = json["repotree"].dictionary
                    {
                        
                        for dict in repoDict
                        {
                            let repo = [dict.0:dict.1]
                            debugPrint(dict.0,dict.1)
                            self.docsCategories = DocsCategories(jsonDictionary: repo, hasMenu: false, itemNumber: 0)
                            self.repotreeArray.append(self.docsCategories!)
                        }
                        
                        
                        
                        
                    }
                    
                    if  let userDict = json["usertree"].dictionary
                    {
                        
                        for dict in userDict
                        {
                            let user = [dict.0:dict.1]
                            debugPrint(dict.0,dict.1)
                            self.docsCategories = DocsCategories(jsonDictionary: user, hasMenu: false, itemNumber: 0)
                            self.usertreeArray.append(self.docsCategories!)
                        }
                        
                    }
                    
                    if (self.usertreeArray.count > 0 && self.repotreeArray.count > 0)
                    {
                        let dumiDict = [String:JSON]()
                        for (var i : Int = 1; i <= 2 ; i++)
                        {
                            self.docsCategories = DocsCategories(jsonDictionary: dumiDict, hasMenu: true, itemNumber: i)
                            self.menuTreeArray.append(self.docsCategories!)
                        }
                        
                        self.performSegueWithIdentifier("menuDocSegue", sender: self)
                        
                    }
                    else
                    {
                        self.performSegueWithIdentifier("docSegue", sender: self)
                    }
                   */

                    
                }
                else
                {
                    
                }
        }
    }
    
    func contactCreation()
    {
        
        Alamofire.request(.GET, (urlManager?.ContactURL)!, parameters: ["access_token":NSUserDefaults.init().objectForKey("token")!])
            
            .responseJSON { response in
                print(response.request)  // original URL request
                print(response.response) // URL response
                print(response.data)     // server data
                print(response.result)   // result of response serialization
                
                if let _ = response.result.value {
                    
                    let json = JSON(data: response.data!)
                    debugPrint(json, terminator: "")
                    if let response = json["contacts"].array
                    {
                        for Dictionary in response
                        {
                            self.contact = ContactObject(jsonDictionary: Dictionary)
                            
                            if let _ = self.contact
                            {
                                self.performSegueWithIdentifier("contactSegue", sender:self)
                            }
                            
                        }
                        
                    }
                    
                }
                else
                {
                    
                }
        }
        

    }
    
// MARK: - Selection
    
    func typeOfServices(typeOfService: Int)
    {
        
        switch typeOfService
        {
        case 1:
            
            
            if let native = self.user?.container?.service?.identifier
            {
                typeOfNativeService(native)
            }
            
            
            break
            
        case 2:
            self.performSegueWithIdentifier("webSegue", sender: self)
            break
            
            
        case 3:
            self.performSegueWithIdentifier("marketingSegue", sender: self)
            break
            
        case 5:
            self.performSegueWithIdentifier("webSegue", sender: self)
            break
            
        case 6:
            self.performSegueWithIdentifier("webSegue", sender: self)
            break
            
            
            
        default :
            
            
            break
            
        }
        
        
    }
    
    func typeOfNativeService(nativeService: Int)
    {
        
        switch nativeService
        {
            
        case 1:
            break
        case 2:
            if self.user?.container?.service?.active != 0
            {
                docmanCreation()
            }
            break
        case 3:
            if self.user?.container?.service?.active != 0
            {
                docmanCreation()
            }
            break
        case 4:
            break
        case 5:
            break
        case 6:
            break
        case 7:
            break
        case 8:
            break
        case 9:
            break
        case 10:
            break
        case 11:
            break
        case 12:
            break
        case 13:
            break
        case 14:
            break
        case 15:
            break
        case 16:
            break
        case 17:
            break
        case 18:
            break
        case 19:
            break
        case 20:
            
            if self.user?.container?.service?.active != 0
            {
                contactCreation()
            }
            
            break
        case 21:
            break
        case 22:
            break
        case 23:
            break
        case 24:
            break
        case 25:
            break
        case 26:
            break
        case 27:
            break
        case 28:
            break
        case 29:
            break
        case 30:
            break
        case 31:
            break
        case 32:
            break
        case 53:
            if self.user?.container?.service?.active != 0
            {
                contactCreation()
            }
            break
        default:
            break
            
        }
        
    }
    
    
    func categoryService()
    {
        if let active = self.user?.container?.category?.active
        {
            if active != 0
            {
                if let subServices = self.user?.container?.category?.arrayOfSubservices
                {
                    if (subServices.count >= 1 && subServices.count < 2)
                    {
                        
                        for  var i : Int = 0 ; i < subServices.count ; i++
                        {
                            
                            self.user?.container?.service = subServices[i] as? ServiceObject
                            
                            let serviceType = self.user?.container?.service?.type
                            
                            typeOfServices(serviceType!)
                            
                        }
                    }
                    else
                    {
                        self.performSegueWithIdentifier("subMenuSegue", sender: self)
                    }
                }
                
            }
        }
        
    }
    
    func typeOfCategories(category: Int)
    {
        switch category
        {
            
        case 1:
            categoryService()
            break
        case 2:
            categoryService()
            break
        case 3:
            categoryService()
            break
        case 4:
            categoryService()
            break
        case 5:
            categoryService()
            break
        case 6:
            categoryService()
            break
        case 7:
            categoryService()
            break
        case 8:
            categoryService()
            break
        case 9:
            categoryService()
            break
        case 10:
            categoryService()
            break
        case 11:
            categoryService()
            break
        case 12:
            categoryService()
            break
        case 13:
            categoryService()
            break
        case 14:
            categoryService()
            break
        case 15:
            categoryService()
            break
        case 16:
            categoryService()
            break
        case 17:
            categoryService()
            break
        case 18:
            categoryService()
            break
        case 19:
            categoryService()
            break
        case 20:
            categoryService()
            break
        case 21:
            categoryService()
            break
        case 22:
            categoryService()
            break
        case 23:
            categoryService()
            break
        case 24:
            categoryService()
            break
        case 25:
            categoryService()
            break
        case 26:
            categoryService()
            break
        case 27:
            categoryService()
            break
        case 28:
            categoryService()
            break
        case 29:
            categoryService()
            break
        case 30:
            categoryService()
            break
        case 31:
            categoryService()
            break
        case 32:
            categoryService()
            break
        case 33:
            categoryService()
            break
        case 34:
            categoryService()
            break
        case 35:
            categoryService()
            break
        case 36:
            categoryService()
            break
        case 37:
            categoryService()
            break
        case 38:
            categoryService()
            break
        case 39:
            categoryService()
            break
        case 40:
            categoryService()
            break
        default:
            break
            
        }
        
        
    }
    

    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        
        if segue.identifier == "webSegue"
        {
            let webVC = segue.destinationViewController as! WebViewController
            webVC.partner = self.partner
            webVC.webURL =  (self.user?.container?.service?.apiURL)!
            debugPrint((self.user?.container?.service?.apiURL)!)
            
        }
        if segue.identifier == "subMenuSegue"
        {
            let subMenuVC = segue.destinationViewController as! SubMainMenuViewController
            subMenuVC.user = self.user
            subMenuVC.partnership = self.partner
            subMenuVC.arrayOfSubServices = (self.user?.container?.category?.arrayOfSubservices)! 
            debugPrint((subMenuVC.user?.container?.category?.arrayOfSubservices?.count)!)
            
        }
        
        if segue.identifier == "marketingSegue"
        {
            let marketVC = segue.destinationViewController as! MarketingVC
            marketVC.user = self.user
            marketVC.partner = self.partner
            marketVC.youTubeURL = self.user?.container?.service?.apiURL!
            
        }
        
        if segue.identifier == "contactSegue"
        {
            let contactVC = segue.destinationViewController as! ContactViewController
            contactVC.user = self.user
            contactVC.partner = self.partner
            contactVC.contact = self.contact
            
            
        }
        
        if segue.identifier == "menuDocSegue"
        {
            let menuDocVC = segue.destinationViewController as! MenuDocViewController
            menuDocVC.userTreeArray = self.usertreeArray
            menuDocVC.repoTreeArray = self.repotreeArray
            menuDocVC.menuTreesArray = self.menuTreeArray
            menuDocVC.partnership = self.partner
            menuDocVC.userOb = self.user
        }
        
        if segue.identifier == "docSegue"
        {
            //let docVC = segue.destinationViewController as! DocsViewController
        }
        
        
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    

}
