//
//  MarketingVC.swift
//  Lupenrein
//
//  Created by Carlos Fernández López on 13/12/15.
//  Copyright © 2015 streamnow. All rights reserved.
//

import UIKit

class MarketingVC: UIViewController,YTPlayerViewDelegate {
    
    
    @IBOutlet weak var playerView: YTPlayerView!
    
    var nameService : String?
    var youTubeURL : String?
    var user : userObject?
    var releaseM : ReleaseManager?
    var partner : String?
    
    @IBOutlet weak var navBarImage: UIImageView!
    
    func partnerSettings()
    {
        if let name = self.partner
        {
            releaseM = ReleaseManager(initWithPartner: name)
            self.navBarImage.image = UIImage(imageLiteral: (releaseM?.navBarColor)!)
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        partnerSettings()
        
        let swipeGesture : UISwipeGestureRecognizer = UISwipeGestureRecognizer.init(target: self, action: Selector("backToMainMenu"))
        swipeGesture.direction = .Down
        self.view!.addGestureRecognizer(swipeGesture)

        
        self.playerView.delegate = self
        
        self.playerView.sizeToFit()
        
        self.playerView.loadWithVideoId(self.youTubeURL!)
        
        

        // Do any additional setup after loading the view.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    func backToMainMenu()
    {
        self.dismissViewControllerAnimated(true) { () -> Void in
            
        }
        
    }
    
// MARK: - Delegates Methods
    
    func playerViewDidBecomeReady(playerView: YTPlayerView!) {
        
        self.playerView.playVideo()
        
    }

    func playerView(playerView: YTPlayerView!, didChangeToState state: YTPlayerState) {
        
        /*
        switch (state) {
        case kYTPlayerStateBuffering:
            break;
        case kYTPlayerStatePlaying:
            NSLog(@"Started playback");
            break;
        case kYTPlayerStatePaused:
            NSLog(@"Paused playback");
            break;
        case kYTPlayerStateEnded:
            {
                [self.PlayerView stopVideo];
                //[self contactPopUp];
            }
            
            break;
        default:
            break;
        }
*/

    }



    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
