<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications_send extends MY_Controller {

	var $model = 'clients_m';
	var $notification_id;

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-bullhorn';
		$this->main_title = lang('menu_notifications');
		$this->main_tip = lang('notifications_tip');
	}
	
	function index($notification_id)
	{
		$this->add_pre_breadcum('notifications', '<i class="fa fa-bullhorn"></i> '. lang('menu_notifications'));
		$name = strtolower(get_class($this));
		$data = array();
		$data['values'] = array('id' => $notification_id);
		$data['table_id'] = $name."_table"; 
		$data['toolbar'] = ''; 
		$data['items_source'] = $name.'/table/'.$notification_id; 
		$data['items_table'] = $this->_get_items('table');
		$data['content_view'] = "crud/table";
		$this->show_template('notifications/edit', $data);
	}
	
	public function table($notification_id)
	{
		$this->notification_id = $notification_id;
		$this->load->view('output/json', array('json' => $this->_ajax_table()));
	}
	
	public function send($client_id)
	{
        $notification_id = $this->input->post('notification_id');

        if(!$this->notify($notification_id, $client_id)){
            echo lang('notification_send_error');
            return;
        }

		$this->load->model('notifications_clients_m');
		$id = $this->notifications_clients_m->insert(array('client_id' => $client_id, 'notification_id' => $notification_id, 'push_sent' => 1));
		if($id>0){
			echo lang('notification_send_ok');
		}else{
			echo lang('notification_send_error');
		}
	}

    private function notify($notification_id, $client_id)
    {
        if (!$notification_id || !$client_id)
            return false;

        // notification
        $this->load->model('notifications_m');
        $notification = $this->notifications_m->get_one($notification_id);
        if (!$notification || !isset($notification['push']) || $notification['push'] != 1)
            return false;

        // client
        $this->load->model('clients_m');
        $client = $this->clients_m->get_one($client_id);
        if (!$client || !isset($client['external_id']))
            return false;

        return push_send($client['external_id'], lang("app_title") . ': ' . $notification['title']);

//		$text = $notification['title'];
//		$token = '6e8be4482036f55b0c328d76faa2baaf47f4d86f9c01d374031c7ef8b16cda2d';
//		$ca_path = realpath(APPPATH.'/certs/entrust_root_certification_authority.pem');
//		$cert_path = realpath(APPPATH.'/certs/SNAppPushProduction.pem');
//		$autoload_path = realpath(APPPATH.'libraries/ApnsPHP/Autoload.php');
//		$custom_logger_path = realpath(APPPATH.'libraries/ApnsPHP_custom/custom_logger.php');
//
//		date_default_timezone_set('Europe/Zurich');
//		require_once $autoload_path;
//		require_once $custom_logger_path;
//		$push = new ApnsPHP_Push(
//			ApnsPHP_Abstract::ENVIRONMENT_PRODUCTION,
//			$cert_path
//		);
//		$custom_logger = new Custom_logger();
//		$push->setLogger($custom_logger);
//		$push->setRootCertificationAuthority($ca_path);
//		$push->setProviderCertificatePassphrase('password');
//		$push->connect();
//		// Instantiate a new Message with a single recipient
//		$message = new ApnsPHP_Message($token);
//		$message->setBadge(1);
//		$message->setText($text);
//		$message->setSound('default');
//		$message->setExpiry(60);
//		// Add the message to the message queue
//		$push->add($message);
//		// Send all messages in the message queue
//		$push->send();
//		// Disconnect from the Apple Push Notification Service
//		$push->disconnect();
//		// Examine the error message container
//		$aErrorQueue = $push->getErrors();
//		//empty is ok
//		if(!empty($aErrorQueue)){
//			ob_start();
//			var_dump($aErrorQueue);
//			$result = ob_get_clean();
//			log_message('error', date('r').' ApnsPHP['.getmypid().']: Found errors debug info:'.$result);
//			return FALSE;
//		}else{
//			return TRUE;
//		}
    }

	function _callback_row($key, $item, &$rows)
	{
		switch ($key) {
			case 'id':
				$id = $item;
				$item = form_open('notifications_send/send/'.$id, array('id' => 'ns_'.$id, 'target' => '#ns_'.$id, 'class' => 'ajax'));
				$item .= form_hidden('notification_id', $this->notification_id);
				$item .= '<button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-send"></i> '.lang('notification_send').'</button>';
				$item .= form_close();
				break;
		}
		 return $item===NULL? '' : $item; 
	}

	function _callback_filter()
	{
		return "clients.id NOT IN (SELECT notifications_clients.client_id FROM notifications_clients WHERE notification_id=".$this->notification_id.")";
	}
	
}