<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Parameters extends MY_Controller {

	var $model = 'parameters_m';
	var $edit_view  = 'parameters/edit';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-wrench';
		$this->main_title = lang('menu_parameters');
		$this->main_tip = lang('parameters_tip');
		$this->create_title = lang('parameters_create');
	}

	function index()
	{
		$this->_table(anchor('parameters/create','<i class="fa fa-plus"></i> '.lang('parameters_create'), 'class="btn btn-primary btn-sm"'));
	}
	
	function edit($id)
	{
		$client = $this->parameters_m->get_one($id);
		$this->main_title = $client['name'];
		parent::edit($id);
	}

	function _callback_previous_row(&$row)
	{
		$item = anchor('parameters/edit/'.$row->id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm"');
		$item .= "&nbsp;";
		$item .= anchor('parameters/delete/'.$row->id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm"');

		$row->action = $item;
	}
}