<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_categories_m extends MY_Model {
	
	var $table = "clients_categories";
	private $parent_id;
	private $client_id;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_tree($client_id)
	{
		$this->load->model('clients_docs_m');
		$tree = $this->_get_tree($client_id, NULL);
		$docs = $this->clients_docs_m->get_by_category_id($client_id, NULL);
		foreach($docs as $kdoc=>$doc){
			$docs[$kdoc]['id'] = 'dc_'.$docs[$kdoc]['id'];
			unset($docs[$kdoc]['category_id']);
			unset($docs[$kdoc]['client_id']);
			unset($docs[$kdoc]['image']);
			unset($docs[$kdoc]['order']);
			unset($docs[$kdoc]['doc']);
		}
		if(!empty($docs)){$tree['docs'] = $docs;}
		return $tree;
	}
	
	private function _get_tree($client_id, $parent_id=NULL)
	{
		$tree = $this->get_by_parent($client_id, $parent_id);
		foreach($tree as $key=>$item){
			$tree[$key]['id'] = 'cc_'.$tree[$key]['id'];
			unset($tree[$key]['parent_id']);
			unset($tree[$key]['client_id']);
			unset($tree[$key]['image']);
			unset($tree[$key]['order']);
			$childs = $this->_get_tree($client_id, $item['id']);
			if(!empty($childs)){$tree[$key]['childs'] = $childs;}
			$docs = $this->clients_docs_m->get_by_category_id($client_id, $item['id']);
			foreach($docs as $kdoc=>$doc){
				$docs[$kdoc]['id'] = 'dc_'.$docs[$kdoc]['id'];
				unset($docs[$kdoc]['category_id']);
				unset($docs[$kdoc]['client_id']);
				unset($docs[$kdoc]['image']);
				unset($docs[$kdoc]['order']);
				unset($docs[$kdoc]['doc']);
			}
			if(!empty($docs)){$tree[$key]['docs'] = $docs;}
		}
		return $tree;
	}
	
	function get_by_parent($client_id, $parent_id=NULL)
	{
		$this->db->where('client_id', $client_id);
		if($parent_id==NULL){
			$this->db->where('parent_id IS null');
		}else{
			$this->db->where('parent_id', $parent_id);
		}
		return $this->get_all();
	}
	
	function set_parent_id($parent_id)
	{
		$this->parent_id = $parent_id;
	}
	
	function set_client_id($client_id)
	{
		$this->client_id = $client_id;
	}
	
	private function save_model_data(&$data)
	{
		if(isset($this->parent_id) && !isset($data['parent_id'])){
			$data['parent_id'] = $this->parent_id;
		}
		if(isset($this->client_id) && !isset($data['client_id'])){
			$data['client_id'] = $this->client_id;
		}
	}
	
	function _before_insert(&$data)
	{
		$this->save_model_data($data);
	}
	
	function _before_update($id, &$data)
	{
		$this->save_model_data($data);
	}
	
	function getinvoice($client_id)
	{
		$this->db->where('client_id',$client_id);
		$this->db->where('category_name','Invoice');
		$this->db->where('isinvoice',1);
        $query = $this->db->get('clients_categories');
		
		if($query->num_rows() > 0){
			
			$categorydata = $query->row_array();
			return $categorydata['id'];
		} else {
			return '0';
		}
	}
	
	function createinvoice($client_id){
		
		$this->db->where('client_id',$client_id);
		$this->db->where('category_name','Invoice');
		$this->db->where('isinvoice',1);
		$query = $this->db->get('clients_categories');
		
		if($query->num_rows() > 0){
			
			$categorydata = $query->row_array();
			return $categorydata['id'];
			
		} else {
			
			$this->db->where('client_id',$client_id);
			$this->db->where('category_name','Invoice');
			$query = $this->db->get('clients_categories');
			
			if($query->num_rows() > 0){
			
				$categorydata = $query->row_array();
				$dataArray = array("isinvoice" => "1");
				
				$this->db->where('id', $categorydata['id']);
				$this->db->update('clients_categories', $dataArray);
				return $categorydata['id'];
			
			} else {
				
				$dataArray = array(
					'client_id' => $client_id,
					'category_name' => 'Invoice',
					'isinvoice' => 1,
					'order' => 0
				);
				
				$this->db->insert("clients_categories", $dataArray);
				return $this->db->insert_id();
			}
		}
	}
	
	function deactivateinvoice($client_id)
	{
		$this->db->where('client_id',$client_id);
		$this->db->where('category_name','Invoice');
		$this->db->where('isinvoice',1);
        $query = $this->db->get('clients_categories');
		
		if($query->num_rows() > 0){
			
			$categorydata = $query->row_array();
			$dataArray = array("isinvoice" => "0");
			$this->db->where('id', $categorydata['id']);
			$this->db->update('clients_categories', $dataArray);
				
			return $categorydata['id'];
		} else {
			return '0';
		}
	}
	
	function get_custom_one($id)
	{
		$this->db->join('admin', 'admin.id = '.$this->table.'.admin_id', 'left outer'); 
		$this->db->select($this->table.'.*, admin.user as user, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key);
		$this->db->where($this->table.'.'.$this->primary_key, $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		$data = $this->_get_virtuals($id, $data);
		return $data;
	}
	
	function getidbycategoryid($cat_ID){
		$this->db->where('cat_id', $cat_ID);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		return $data;
	}
	
	function setclientcategories($dataArray){
		$this->db->insert($this->table, $dataArray);
		return $this->db->insert_id();
	}
	
	function updateclientcategories($cat_ID, $client_id, $dataArray){
		
		$this->db->where('cat_id', $cat_ID);
		$this->db->where('client_id', $client_id);
		$this->db->update($this->table, $dataArray);
		return $this->db->affected_rows();
	}
	
	function deleteclientcategories($cat_ID, $client_id){
		//var_dump("testing");exit();
		$this->db->where('cat_id', $cat_ID);
		$this->db->where('client_id', $client_id);
		$this->db->delete($this->table);
		return $this->db->affected_rows();
	}
}