<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_m extends MY_Model {
	
	var $table = "clients";
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_by_external_id($id)
	{
		$this->primary_key = 'external_id';
		$ret = $this->get_one($id);
		$this->primary_key = 'id';
		return $ret;
	}
	
	function delete_external_id($id)
	{
		$this->primary_key = 'external_id';
		$ret = $this->delete($id);
		$this->primary_key = 'id';
		return $ret;
	}
	
	function _callback_table()
	{
		$this->db->join('clients_categories', 'LOWER('.$this->table.'.id)=LOWER(clients_categories.client_id) and LOWER(clients_categories.isinvoice)=1', 'LEFT');
		if($this->session->userdata('user_role') == 2){
			$this->db->where('clients.partner_id',$this->session->userdata('business_partner'));
		}
	}
	
	function update_by_external_id($id, $data)
	{
		$this->primary_key = 'external_id';
		$ret = $this->update($id, $data);
		$this->primary_key = 'id';
		return $ret;
	}
	
	function checkclientinvoice($client_id){
		$this->db->where('client_id',$client_id);
		$this->db->where('category_name','Invoice');
		$this->db->where('isinvoice',1);
        $query = $this->db->get('clients_categories');
		
		if($query->num_rows() > 0){
			$categorydata = $query->row_array();
			return $categorydata['id'];
		} else {
			return 0;
		}
	}
	
	function clientinvoice($client_id){
		
		$this->db->where('client_id',$client_id);
		$this->db->where('category_name','Invoice');
		$this->db->where('isinvoice',1);
        $query = $this->db->get('clients_categories');
		
		if($query->num_rows() > 0){
			$categorydata = $query->row_array();
			
			$dataArray = array("isinvoice" => "0");
				
			$this->db->where('id', $categorydata['id']);
			$this->db->update('clients_categories', $dataArray);
			
			return $categorydata['id'];
			
			/*
			$this->db->where('category_id', $cid);
			$this->db->delete('clients_docs');
			
			$this->db->where('id', $cid);
			$this->db->delete('clients_categories');*/
		} else {
			
			$this->db->where('client_id',$client_id);
			$this->db->where('category_name','Invoice');
			$query = $this->db->get('clients_categories');
			
			if($query->num_rows() > 0){
			
				$categorydata = $query->row_array();
				$dataArray = array("isinvoice" => "1");
				
				$this->db->where('id', $categorydata['id']);
				$this->db->update('clients_categories', $dataArray);
				return $categorydata['id'];
			
			} else {
				
				$dataArray = array(
					'client_id' => $client_id,
					'category_name' => 'Invoice',
					'isinvoice' => 1,
					'order' => 0
				);
				
				$this->db->insert("clients_categories", $dataArray);
				return $this->db->insert_id();
			}
		}
	}
}	