<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_repo_docs_m extends MY_Model {
	
	var $table = "repo_docs_clients";
	private $doc_id;
	private $client_id;
	
	function __construct()
    {
        parent::__construct();
		$this->load->model('repo_categories_m');
		$this->load->model('repo_docs_m');
    }
	
	function get_by_client_id($client_id)
	{
		$this->db->where('client_id', $client_id);
		return $this->get_all();
	}
	
	function get_by_repo_doc_id($repo_doc_id)
	{
		$this->db->where('repo_doc_id', $repo_doc_id);
		$query = $this->db->get($this->table);
		$data = $query->num_rows();
		return $data;
	}
	
	function get_esb_by_repo_doc_id($repo_doc_id)
	{
		$this->db->join('clients', 'clients.id = '.$this->table.'.client_id', 'left outer'); 
		$this->db->select('clients.external_id as external_id');
		$this->db->where($this->table.'.repo_doc_id', $repo_doc_id);
		$query = $this->db->get($this->table);
		$data = $query->result_array();
		return $data;
	}
	
	function get_by_client_doc($client_id, $doc_id)
	{
		$this->db->where('client_id', $client_id);
		$this->db->where('repo_doc_id', $doc_id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		return $data;
	}
	
	function set_client_doc($dataArray){
		
	   $this->db->insert($this->table, $dataArray);
	   $insert_id = $this->db->insert_id();

	   return  $insert_id;
	}
	
	function unset_by_client_doc($client_id, $doc_id)
	{
		$this->db->where('client_id', $client_id);
		$this->db->where('repo_doc_id', $doc_id);
		$this->db->delete($this->table);
		return true;
	}
	
	function get_ids_by_client_id($client_id)
	{
		$docs = $this->get_by_client_id($client_id);
		$docs_ids = array();
		foreach($docs as $doc){
			$docs_ids[] = $doc['repo_doc_id'];
		}
		return $docs_ids;
	}
	
	function get_tree($client_id)
	{
		$docs = $this->get_by_client_id($client_id);
		$docs_ids = array();
		$cats_ids = array();
		foreach($docs as $doc){
			$docs_ids[] = $doc['repo_doc_id'];
			$cats = $this->repo_docs_m->get_cats_branch($doc['repo_doc_id']);
			foreach($cats as $cat_id){
				if(!in_array($cat_id, $cats_ids)){
					$cats_ids[] = $cat_id;
				}
			}
		}
		$tree = $this->repo_categories_m->get_filtered_tree($cats_ids, $docs_ids);
		return $tree;
	}

	private function save_model_data(&$data)
	{
		if(isset($this->doc_id) && !isset($data['repo_doc_id'])){
			$data['repo_doc_id'] = $this->doc_id;
		}
		if(isset($this->client_id) && !isset($data['client_id'])){
			$data['client_id'] = $this->client_id;
		}
	}
	
	function set_doc_id($doc_id)
	{
		$this->doc_id = $doc_id;
	}
	
	function set_client_id($client_id)
	{
		$this->client_id = $client_id;
	}
	
	function _before_insert(&$data)
	{
		$this->save_model_data($data);
        $this->load->model('repo_docs_m');
        $doc = $this->repo_docs_m->get_one($data['repo_doc_id']);
        if($doc && $doc['push']) {
            $this->load->model('clients_m');
            $client = $this->clients_m->get_one($data['client_id']);
            push_send($client['external_id'], lang("app_title") . ': ' . $data['name']);
        }
	}
	
	function _before_update($id, &$data)
	{
		$this->save_model_data($data);
	}
	
}