<!DOCTYPE html>
<html>
<head>
    <title>Winterthur Web Service</title>
    <link href='https://fonts.googleapis.com/css?family=Droid+Sans:400,700' rel='stylesheet' type='text/css'/>
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css">
    <link href='swagger-ui/css/highlight.default.css' media='screen' rel='stylesheet' type='text/css'/>
    <link href='swagger-ui/css/screen.css' media='screen' rel='stylesheet' type='text/css'/>
    <script type="text/javascript" src="swagger-ui/lib/shred.bundle.js"></script>
    <script src='swagger-ui/lib/jquery-1.8.0.min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/jquery.slideto.min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/jquery.wiggle.min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/jquery.ba-bbq.min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/handlebars-1.0.0.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/underscore-min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/backbone-min.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/swagger.js' type='text/javascript'></script>
    <script src='swagger-ui/js/swagger-ui.js' type='text/javascript'></script>
    <script src='swagger-ui/lib/highlight.7.3.pack.js' type='text/javascript'></script>
    <link href="favicon.ico" rel="shortcut icon" />
    <script type="text/javascript">
        $(function () {
            window.swaggerUi = new SwaggerUi({
                url: "<?php echo 'https://'.$_SERVER['HTTP_HOST'].'/'.dirname($_SERVER['PHP_SELF']).'/api/index.php' ?>",
                dom_id: "swagger-ui-container",
                supportedSubmitMethods: ['get', 'post', 'put', 'delete'],
                onComplete: function(){
                    log("Loaded SwaggerUI")
                    $('pre code').each(function(i, e) {hljs.highlightBlock(e)});
                },
                onFailure: function(data) {
                    log("Unable to Load SwaggerUI");
                },
                docExpansion: "none"
            });
            $('#input_apiKey').change(function() {
                var key = $('#input_apiKey')[0].value;
                log("key: " + key);
                if(key && key.trim() != "") {
                    log("added key " + key);
                    window.authorizations.add("key", new ApiKeyAuthorization("api_key", key, "query"));
                }
            })
            window.swaggerUi.load();
        });
    </script>
</head>

<body>
<div id='header'>
    <div class="swagger-ui-wrap">
        <a id="logo" href="#"><i class="fa fa-book"></i> Winterthur Web Service</a>

        <form id='api_selector'>
            <div class='input'><input placeholder="http://example.com/api" id="input_baseUrl" name="baseUrl" type="hidden"/></div>
            <div class='input'><input placeholder="api_key" id="input_apiKey" name="apiKey" type="hidden"/></div>
            <div class='input'><a id="explore" href="#">Explore</a></div>
        </form>
    </div>
</div>

<div id="message-bar" class="swagger-ui-wrap">
    &nbsp;
</div>

<div id="swagger-ui-container" class="swagger-ui-wrap">

</div>

</body>