<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_docs extends MY_Controller {

	var $model = 'clients_docs_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-file-o';
		$this->create_title = lang('repo_docs_create');
	}
	
	function create($client_id, $parent_id=NULL)
	{
		$this->clients_docs_m->set_category_id($parent_id);
		$this->clients_docs_m->set_client_id($client_id);
		$parent_id = $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$data = $this->_create('clients_repo/tree_panel/'.$client_id.'/'.$parent_id, '#clients_repo_tree_content');
		$this->load->view('crud/create', $data);
	}
	
	function edit($client_id, $id)
	{
		$tree_id = 'd_'.$id;
		$data = $this->_edit($id, 'clients_repo/tree_panel/'.$client_id.'/'.$tree_id, '#clients_repo_tree_content');
		$this->load->view('crud/edit', $data);
	}
	
	function delete($client_id, $id)
	{
		$doc = $this->clients_docs_m->get_one($id);
		$cat_id = $doc['category_id']==NULL ? 'root' : 'c_'.$doc['category_id'];
		$data = $this->_delete($id, 'clients_repo/tree_panel/'.$client_id.'/d_'.$id, '#clients_repo_tree_content', 'clients_repo/tree_panel/'.$client_id.'/'.$cat_id, FALSE);
		$this->load->view('crud/delete', $data);
	}
	
}