<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Repo extends MY_Controller {

	var $model = '';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-book';
		$this->main_title = lang('menu_repo');
		$this->main_tip = lang('repo_tip');
	}

	function index()
	{
		$this->_tree($this->tree_panel());
	}
	
	function tree_source()
	{
		$id = $this->input->post('id');
		$data = array();
		if($id=='#'){
			$data[] =  array('id' => 'root', 
						'children' => TRUE, 
						'text' => lang('repo_root'), 
						'icon' => 'fa fa-book',
						'state' => array('opened' => TRUE)
					);
		}
		if($id=='root'){
			$this->load->model('repo_categories_m');
			$cats = $this->repo_categories_m->get_by_parent(null);
			foreach($cats as $cat){
				$data[] = array('id' => 'c_'.$cat['id'], 
								'children' => TRUE, 
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
			}
			$this->load->model('repo_docs_m');
			$docs = $this->repo_docs_m->get_by_category_id(null);
			foreach($docs as $doc){
				$data[] = array('id' => 'd_'.$doc['id'], 
								'children' => FALSE, 
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
			}
		}
		if(substr($id, 0, 2)=='c_'){
			$id = str_replace('c_', '', $id);
			$this->load->model('repo_categories_m');
			$cats = $this->repo_categories_m->get_by_parent($id);
			foreach($cats as $cat){
				$data[] = array('id' => 'c_'.$cat['id'], 
								'children' => TRUE, 
								'icon' => 'fa fa-folder-open-o',
								'text' => $cat['category_name']);
			}
			$this->load->model('repo_docs_m');
			$docs = $this->repo_docs_m->get_by_category_id($id);
			foreach($docs as $doc){
				$data[] = array('id' => 'd_'.$doc['id'], 
								'children' => FALSE, 
								'icon' => 'fa fa-file-o',
								'text' => $doc['name']);
			}
		}
		
		$this->load->view('output/json', array('json' =>$data));
	}
	
	function tree_panel($id = NULL)
	{
		if($id==NULL){
			$refresh = FALSE;
			$id = $this->input->post('id');
		}else{
			$refresh = TRUE;
		}
		$item_tree_id = $id;
		$data = array();
		if(!$id){
			$data = $this->_panel_welcome();
			return $this->load->view('items/box', $data, TRUE);
		}elseif($id=='root'){
			$data = $this->_panel_root();
		}else{
			switch (substr($id, 0, 2)) {
				case 'c_':
					$id = str_replace('c_', '', $id);
					$data = $this->_panel_category($id);
					break;
				case 'd_':
					$id = str_replace('d_', '', $id);
					$data = $this->_panel_document($id);
					break;
			}
		}
		$this->load->view('items/box', $data);
		if($refresh){
			$this->load->view('crud/tree_refresh', array('tree_id' => '#repo_tree', 'id' => $item_tree_id));
		}
	}
	
	function _panel_welcome()
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lang('repo_management');
		$data['box_content'] = $this->load->view('repo/welcome', NULL, TRUE);
		return $data;
	}
	
	function _panel_root()
	{
		$data = array();
		$data['box_icon'] = "fa fa-book";
		$data['box_title'] = lang('repo_root');
		$data['box_content'] = $this->load->view('repo/root', NULL, TRUE);
		//if($this->session->userdata('user_role') == 1){
			$data['box_buttons'] = anchor('repo_categories/create','<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#repo_tree_content"');
			$data['box_buttons'].= anchor('repo_docs/create','<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#repo_tree_content"');
		//}
		return $data;
	}
	
	function _panel_category($id)
	{
		$this->load->model('repo_categories_m');
		$cat = $this->repo_categories_m->get_custom_one($id);
		if(empty($cat)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-folder-o";
		$data['box_title'] = lang('category')." ".$cat['category_name'];
		$data['box_content'] = $this->load->view('repo/category', $cat, TRUE);
		$data['box_top_buttons'] = anchor('repo_categories/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#repo_tree_content"');
		$data['box_top_buttons'].= "&nbsp;"; 
		//if($this->session->userdata('user_role') == 1){
			$data['box_top_buttons'].= anchor('repo_categories/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#repo_tree_content"');
			$data['box_buttons'] = anchor('repo_categories/create/'.$id,'<i class="fa fa-folder-o"></i> '.lang('repo_categories_create'), 'class="btn btn-primary btn-sm" target="#repo_tree_content"');
			$data['box_buttons'].= anchor('repo_docs/create/'.$id,'<i class="fa fa-file-o"></i> '.lang('repo_docs_create'), 'class="btn btn-primary btn-sm pull-right" target="#repo_tree_content"');
		//}
		return $data;
	}
	
	function _panel_document($id)
	{
		$this->load->model('repo_docs_m');
		$doc = $this->repo_docs_m->get_custom_one($id);
		if(empty($doc)){show_404();}
		$data = array();
		$data['box_icon'] = "fa fa-file-o";
		$data['box_title'] = lang('document')." ".$doc['name'];
		$data['box_content'] = $this->load->view('repo/doc', $doc, TRUE);
		$data['box_top_buttons'] = anchor('repo_docs/edit/'.$id,'<i class="fa fa-pencil"></i> '.lang('edit'), 'class="btn btn-success btn-sm" target="#repo_tree_content"');
		$data['box_top_buttons'].= "&nbsp;"; 
		//if($this->session->userdata('user_role') == 1){
			$data['box_top_buttons'].= anchor('repo_docs/delete/'.$id,'<i class="fa fa-times"></i> '.lang('delete'), 'class="btn btn-danger btn-sm" target="#repo_tree_content"');
		//}
		return $data;
	}
}