<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Repo_categories extends MY_Controller {

	var $model = 'repo_categories_m';

	function __construct()
    {
        parent::__construct();
		$this->icon = 'fa fa-folder-o';
		$this->create_title = lang('repo_categories_create');
	}
	
	function create($parent_id=NULL)
	{
		$this->repo_categories_m->set_parent_id($parent_id);
		$parent_id = $parent_id==NULL ? 'root' : 'c_'.$parent_id;
		$data = $this->_create('repo/tree_panel/'.$parent_id, '#repo_tree_content');
		$this->load->view('crud/create', $data);
	}
	
	function edit($id)
	{
		$tree_id = 'c_'.$id;
		$data = $this->_edit($id, 'repo/tree_panel/'.$tree_id, '#repo_tree_content');
		$this->load->view('crud/edit', $data);
	}

	function delete($id)
	{
		$cat = $this->repo_categories_m->get_one($id);
		$cat_id = $cat['parent_id']==NULL ? 'root' : 'c_'.$cat['parent_id'];
		$data = $this->_delete($id, 'repo/tree_panel/c_'.$id, '#repo_tree_content', 'repo/tree_panel/'.$cat_id, FALSE);
		$this->load->view('crud/delete', $data);
	}
	
}