<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Clients_docs_m extends MY_Model {
	
	var $table = "clients_docs";
	private $category_id;
	private $client_id;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_by_category_id($client_id, $category_id=NULL)
	{
		$this->db->where('client_id', $client_id);
		if($category_id==NULL){
			$this->db->where('category_id IS null');
		}else{
			$this->db->where('category_id', $category_id);
		}
		return $this->get_all();
	}
	
	private function save_model_data(&$data)
	{
		if(isset($this->category_id) && !isset($data['category_id'])){
			$data['category_id'] = $this->category_id;
		}
		if(isset($this->client_id) && !isset($data['client_id'])){
			$data['client_id'] = $this->client_id;
		}
	}
	
	function set_category_id($category_id)
	{
		$this->category_id = $category_id;
	}
	
	function set_client_id($client_id)
	{
		$this->client_id = $client_id;
	}
	
	function _before_insert(&$data)
	{
		$this->save_model_data($data);
        if ($data['push']) {
            $this->load->model('clients_m');
            $client = $this->clients_m->get_one($data['client_id']);
            push_send($client['external_id'], lang("app_title") . ': ' . $data['name']);
        }
	}
	
	function _before_update($id, &$data)
	{
		$this->save_model_data($data);
	}
	
	function setinvoice($client_id, $category_id, $docname, $orginaldocname)
	{
		$dataArray = array(
			'client_id' => $client_id,
			'category_id' => $category_id,
			'order' => 0,
			'doc' => '/'.$docname,
			'name' => $orginaldocname,
			//'name' => 'invoice'.date('m-d-Y'),
			'description' => 'invoice'.date('m-d-Y'),
		);
		
		$this->db->insert("clients_docs", $dataArray);
		return $this->db->insert_id();
	}
	
	function get_custom_one($id)
	{
		$this->db->join('admin', 'admin.id = '.$this->table.'.admin_id', 'left outer'); 
		$this->db->select($this->table.'.*, admin.user as user, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key);
		$this->db->where($this->table.'.'.$this->primary_key, $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		$data = $this->_get_virtuals($id, $data);
		return $data;
	}
	
	function checkclientdocbydocid_userid($doc_ID, $client_id){
		$this->db->where('doc_id', $doc_ID);
		$this->db->where('client_id', $client_id);
		$query = $this->db->get($this->table);
		$rowcount = $query->num_rows();
		return $rowcount;
	}
	
	function setclientdocument($dataArray){
		$this->db->insert($this->table, $dataArray);
		return $this->db->insert_id();
	}
	
	function updateclientdocument($doc_ID, $client_id, $dataArray){
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 0");
		
        $this->db->where('doc_id', $doc_ID);
		$this->db->where('client_id', $client_id);
		$this->db->update($this->table, $dataArray);
		$rows_cnt =  $this->db->affected_rows();
		
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 1");
		return $rows_cnt;
	}
	
	function deleteclientdocument($doc_ID, $client_id){
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 0");
		
		$this->db->where('doc_id', $doc_ID);
		$this->db->where('client_id', $client_id);
		$this->db->delete($this->table);
		$rows_cnt = $this->db->affected_rows();
		
		//$this->db->query("SET FOREIGN_KEY_CHECKS = 1");
		return $rows_cnt;
	}
}