<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Notifications_clients_m extends MY_Model {
	
	var $table = "notifications_clients";
	
	function __construct()
    {
        parent::__construct();
    }

	function get_by_external_id($external_id, $limit=NULL, $order_field=NULL, $order_direction='DESC')
	{
		$this->db->select('notifications.*');
		if($limit!=NULL){
			$this->db->limit($limit);
		}
		if($order_field!=NULL){
			$this->db->order_by($order_field, $order_direction);
		}
		$this->db->join('clients', $this->table.'.client_id = clients.id');
		$this->db->join('notifications', $this->table.'.notification_id = notifications.id');
		$this->db->where('clients.external_id', $external_id);
		return $this->get_all();
	}
	
	function _callback_table()
	{
		$this->db->join('clients', $this->table.'.client_id = clients.id');
		$this->db->join('notifications', $this->table.'.notification_id = notifications.id');
	}
}