<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Repo_categories_m extends MY_Model {
	
	var $table = "repo_categories";
	private $parent_id;
	
	function __construct()
    {
        parent::__construct();
    }
	
	function get_cats_branch($cat_id, &$ret=null)
	{
		if($ret==NULL){$ret=array();}
		$ret[] = $cat_id;
		$cat = $this->get_one($cat_id);
		if($cat['parent_id'] != NULL){
			$this->get_cats_branch($cat['parent_id'], $ret);
		}
		return $ret;
	}
	
	function get_filtered_tree($cats_ids, $docs_ids)
	{
		$this->load->model('repo_docs_m');
		$tree = $this->_get_filtered_tree($cats_ids, $docs_ids);
		$docs = $this->repo_docs_m->get_filtered_by_category_id($docs_ids, NULL);
		foreach($docs as $kdoc=>$doc){
			$docs[$kdoc]['id'] = 'dr_'.$docs[$kdoc]['id'];
			unset($docs[$kdoc]['category_id']);
			unset($docs[$kdoc]['image']);
			unset($docs[$kdoc]['order']);
			unset($docs[$kdoc]['doc']);
		}
		if(!empty($docs)){$tree['docs'] = $docs;}
		return $tree;
	}
	
	private function _get_filtered_tree($cats_ids, $docs_ids, $parent_id=NULL)
	{
		$tree = $this->get_filtered_by_parent($cats_ids, $parent_id);
		foreach($tree as $key=>$item){
			$tree[$key]['id'] = 'cr_'.$tree[$key]['id'];
			unset($tree[$key]['parent_id']);
			unset($tree[$key]['client_id']);
			unset($tree[$key]['image']);
			unset($tree[$key]['order']);
			$childs = $this->_get_filtered_tree($cats_ids, $docs_ids, $item['id']);
			if(!empty($childs)){$tree[$key]['childs'] = $childs;}
			$docs = $this->repo_docs_m->get_filtered_by_category_id($docs_ids, $item['id']);
			foreach($docs as $kdoc=>$doc){
				$docs[$kdoc]['id'] = 'dr_'.$docs[$kdoc]['id'];
				unset($docs[$kdoc]['category_id']);
				unset($docs[$kdoc]['image']);
				unset($docs[$kdoc]['order']);
				unset($docs[$kdoc]['doc']);
			}
			if(!empty($docs)){$tree[$key]['docs'] = $docs;}
		}
		return $tree;
	}
	
	function get_filtered_by_parent($cats_ids, $parent_id=NULL)
	{
		if(empty($cats_ids)){return array();}
		$this->db->where_in('id', $cats_ids);
		if($parent_id==NULL){
			$this->db->where('parent_id IS null');
		}else{
			$this->db->where('parent_id', $parent_id);
		}
		return $this->get_all();
	}
	
	
	function set_parent_id($parent_id)
	{
		$this->parent_id = $parent_id;
	}
	
	private function save_parent_id(&$data)
	{
		if(isset($this->parent_id) && !isset($data['parent_id'])){
			$data['parent_id'] = $this->parent_id;
		}
	}
	
	function _before_insert(&$data)
	{
		$this->save_parent_id($data);
	}
	
	function _before_update($id, &$data)
	{
		$this->save_parent_id($data);
	}
	
	function get_by_parent($parent_id=NULL)
	{
		if($parent_id==NULL){
			$this->db->where('parent_id IS null');
		}else{
			$this->db->where('parent_id', $parent_id);
		}
		
		if($this->session->userdata('user_role') == 2){
			$this->db->where('business_partner', $this->session->userdata('business_partner'));
		}
		
		return $this->get_all();
	}
	
	function get_custom_one($id)
	{
		$this->db->join('admin', 'admin.id = '.$this->table.'.admin_id', 'left outer'); 
		$this->db->select($this->table.'.*, admin.user as user, '.$this->table.'.'.$this->primary_key.' AS '.$this->primary_key);
		$this->db->where($this->table.'.'.$this->primary_key, $id);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		$data = $this->_get_virtuals($id, $data);
		return $data;
	}
	
	function getidbycategoryid($cat_ID){
		$this->db->where('cat_id', $cat_ID);
		$query = $this->db->get($this->table);
		$data = $query->row_array();
		return $data;
	}
	
	function setrepocategories($dataArray){
		$this->db->insert($this->table, $dataArray);
		return $this->db->insert_id();
	}
	
	function updaterepocategories($cat_ID, $businesspartnerid, $dataArray){
		
		$this->db->where('cat_id', $cat_ID);
		$this->db->where('business_partner', $businesspartnerid);
		$this->db->update($this->table, $dataArray);
		return $this->db->affected_rows();
	}
	
	function deleterepocategories($cat_ID, $businesspartnerid){
		$this->db->where('cat_id', $cat_ID);
		$this->db->where('business_partner', $businesspartnerid);
		$this->db->delete($this->table);
		return $this->db->affected_rows();
	}
}